package tests::ParamTest;

use strict;

use Lire::Param;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();
    $self->init_i18n();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_locale();
    $self->set_up_test_schema();

    my $param = new Lire::Param( 'i18n_domain' => 'lire-test',
                                'name' => 'whatever',
                                'type' => 'string',
                                'description' => '<para>JPEG Files</para>' );
    $self->{'param'} = $param;

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_locale();

    return $self;
}

sub test_description_i18n {
    my $self = $_[0];

    my $param = $self->{'param'};
    $self->assert_str_equals( '<para>JPEG Files</para>',
                              $param->description() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( '<para>Fichiers JPEG</para>',
                              $param->description() );
}

1;
