package tests::PloticusChartWriterTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::I18N qw/ set_fh_encoding ensure_utf8 mark_unicode /;
use Lire::ReportParser::PloticusChartWriter;
use File::Temp qw/ tempfile /;
use Symbol;
use Config;

sub new {
    my $self = shift()->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->{'cfg'}{'ploticus_path'} = '/usr/bin/ploticus';
    $self->{'cfg'}{'lr_chart_font'} = '';

    ( $self->{'tmp_fh'}, $self->{'tmp_filename'} ) = tempfile();

    my $writer =
      new Lire::ReportParser::PloticusChartWriter( 'format' => 'png' );
    $writer->{'pid'} = $self->{'tmp_fh'};
    $writer->{'file'} = $self->{'tmp_filename'};
    $self->{'writer'} = $writer;

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    unlink( $self->{'tmp_filename'} );

    return $self;
}

sub test_ploticus_cmdline {
    my $self = $_[0];

    my $writer = $self->{'writer'};

    $self->assert_died( sub { $writer->_ploticus_cmdline() },
                        qr/missing 'charttype' parameter/ );
    $self->assert_died( sub { $writer->_ploticus_cmdline( 'pie' ) },
                        qr/missing 'filename' parameter/ );
    $self->assert_died( sub { $writer->_ploticus_cmdline( 'pie', 'file' ) },
                        qr/missing 'format' parameter/ );
    $self->assert_died( sub { $writer->_ploticus_cmdline( 'bad_type',
                                                          'file', 'png' ) },
                        qr/invalid 'charttype' parameter: 'bad_type'/ );

    $self->assert_str_equals( "/usr/bin/ploticus -jpg -o output.png delim=tab comment=__COMMENT__ data=- -prefab vbars x=3 y=2 stubvert=yes curve=width=.7 color='rgb(.4,0,.4)' 2>/dev/null",
                              $writer->_ploticus_cmdline( 'histogram', 'output.png', 'jpg' ) );

    $self->assert_str_equals( "/usr/bin/ploticus -png -o output.png delim=tab comment=__COMMENT__ data=- -prefab vbars x=3 y=2 stubvert=yes color='rgb(.4,0,.4)' 2>/dev/null",
                              $writer->_ploticus_cmdline( 'bars', 'output.png', 'png' ) );

    $self->assert_str_equals( "/usr/bin/ploticus -png -o output.png delim=tab comment=__COMMENT__ data=- -prefab pie values=2 labels=3 colors='rgb(.75,0,0) rgb(1,.75,0) rgb(0,.75,0) rgb(0,0,1) rgb(.75,0,1) rgb(.25,.6,.9) rgb(.9,.6,.25) rgb(.5,.8,.6) rgb(.8,.5,.7) rgb(.5,.5,.5)' 2>/dev/null",
                               $writer->_ploticus_cmdline( 'pie', 'output.png', 'png' ) );

    $self->{'cfg'}{'lr_chart_font'} = 'Arial';
    $self->assert_str_equals( "/usr/bin/ploticus -font 'Arial' -png -o output.png delim=tab comment=__COMMENT__ data=- -prefab vbars x=3 y=2 stubvert=yes curve=width=.7 color='rgb(.4,0,.4)' 2>/dev/null",
                              $writer->_ploticus_cmdline( 'histogram', 'output.png', 'png' ) )
}

1;
