package tests::ReportSectionTest;

use strict;

use Lire::ReportSection;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();
    $self->init_i18n();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_locale();
    $self->set_up_test_schema();

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_locale();

    return $self;
}

sub test_title_i18n {
    my $self = $_[0];

    my $sect = new Lire::ReportSection( 'test', 'JPEG Files' );
    $self->assert_str_equals( 'JPEG Files', $sect->title() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( 'Fichiers JPEG', $sect->title() );
}

1;
