package tests::UIIntegerWidgetTest;

use strict;
no warnings 'redefine';

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;

use Curses::UI;

use Lire::UI::Widget;
use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ConfigSpec( 'name' => 'lire' );
    $spec->add( new Lire::Config::IntegerSpec( 'name' => 'test',
                                               'section' => 'programs',
                                               'summary' => 'Test Summary',
                                               'description' => '<para>Test Description</para>' ) );
    $self->{'int_value'} = $spec->get( 'test' )->instance( 'value' => '12345' );
    $self->{'spec'} = $spec;

    return;
}


sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $win = $self->{'window'};
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                     'Lire::UI::IntegerWidget' ) },
                        qr{missing 'value' parameter} );
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::IntegerWidget',
                                                      'Value' => {} ) },
                        qr{'value' parameter should be a 'Lire::Config::Scalar' instance, not 'HASH} ); #'} );#cperl-mode really sucks

    my $widget = $win->add( 'test_widget', 'Lire::UI::IntegerWidget',
                            'value' => $self->{'int_value'} );
    $self->assert( UNIVERSAL::isa( $widget, 'Lire::UI::IntegerWidget' ),
                   "not a Lire::UI::IntegerWidget instance: $widget" );

    my $text_entry = $widget->getobj( 'text_entry' );
    $self->assert( UNIVERSAL::isa( $text_entry, 'Curses::UI::TextEntry' ),
                   "not a Curses::UI::TextEntry instance: $text_entry" );
    $self->assert_str_equals( \&Lire::UI::IntegerWidget::_on_change_cb,
                              $text_entry->{'-onchange'} );
    $self->assert_str_equals( '12345', $text_entry->{'-text'} );

    my $inc_button = $widget->getobj( 'inc_button' );
    $self->assert( UNIVERSAL::isa( $inc_button, 'Curses::UI::Buttonbox' ),
                   "not a Curses::UI::Buttonbox instance: $inc_button" );

    my $dec_button = $widget->getobj( 'dec_button' );
    $self->assert( UNIVERSAL::isa( $inc_button, 'Curses::UI::Buttonbox' ),
                   "not a Curses::UI::Buttonbox instance: $dec_button" );

    return;
}

sub test_on_change_cb {
    my $self = $_[0];

    my $win = $self->{'window'};
    my $widget = $win->add( 'test_widget', 'Lire::UI::IntegerWidget',
                            'value' => $self->{'int_value'} );
    my $text_entry = $widget->getobj( 'text_entry' );
    my $or_value = $text_entry->text();
    $text_entry->text( '654321' );
    Lire::UI::IntegerWidget::_on_change_cb( $text_entry );
    $self->assert_str_not_equals( $or_value, $self->{'int_value'}->get() );
    $self->assert_str_equals( '654321', $self->{'int_value'}->get() );

   $self->{'driver'}->enter_text( '/window/test_widget/text_entry',
                                  "\ca\ck654321abcd" );
   $self->assert_str_equals( '654321', $self->{'int_value'}->get() );
}

sub test_refresh_view {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'test_widget',
                                         'Lire::UI::IntegerWidget',
                                         'value' => $self->{'int_value'} );

    $self->{'int_value'}->set( '162534' );
    $widget->refresh_view();

    my $text_entry = $widget->getobj( 'text_entry' );
    $self->assert_str_equals( '162534', $text_entry->text() );
}

sub test_on_dec_press_cb {
    my $self = $_[0];

    $self->{'int_value'}->set( '162534' );
    my $widget = $self->{'window'}->add( 'test_widget',
                                         'Lire::UI::IntegerWidget',
                                         'value' => $self->{'int_value'} );

    my $dec_button = $widget->getobj( 'dec_button' );
    $dec_button->{'-buttons'}[0]->{'-onpress'}->();

    my $text_entry = $widget->getobj( 'text_entry' );
    $self->assert_str_equals( '162533', $text_entry->text() );
}

sub test_on_inc_press_cb {
    my $self = $_[0];

    $self->{'int_value'}->set( '162534' );
    my $widget = $self->{'window'}->add( 'test_widget',
                                         'Lire::UI::IntegerWidget',
                                         'value' => $self->{'int_value'} );

    my $inc_button = $widget->getobj( 'inc_button' );
    $inc_button->{'-buttons'}[0]->{'-onpress'}->();

    my $text_entry = $widget->getobj( 'text_entry' );
    $self->assert_str_equals( '162535', $text_entry->text() );
}

1;
