package tests::UIStringWidgetTest;

use strict;
no warnings 'redefine';

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;

use Curses::UI;

use Lire::UI::Widget;
use Lire::Test::CursesUIDriver;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );


    my $spec = new Lire::Config::ConfigSpec( 'name' => 'lire' );
    $spec->add( new Lire::Config::StringSpec( 'name' => 'test',
                                                'section' => 'programs',
                                                'summary' => 'Test Summary',
                                                'description' => '<para>Test Description</para>' ) );
    $self->{'string_value'} = $spec->get( 'test' )->instance( 'value' => 'Test Value' );
    $self->{'spec'} = $spec;

    return;
}


sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $win = $self->{'window'};
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                     'Lire::UI::StringWidget' ) },
                        qr{missing 'value' parameter} );
    $self->assert_died( sub { my $widget = $win->add( 'test_widget',
                                                      'Lire::UI::StringWidget',
                                                      'Value' => {} ) },
                        qr{'value' parameter should be a 'Lire::Config::Scalar' instance, not 'HASH} ); #'} );#cperl-mode really sucks

    my $widget = $win->add( 'test_widget', 'Lire::UI::StringWidget',
                            'value' => $self->{'string_value'} );
    $self->assert( UNIVERSAL::isa( $widget, 'Lire::UI::StringWidget' ),
                   "not a Lire::UI::StringWidget instance: $widget" );

    $self->assert_str_equals( \&Lire::UI::StringWidget::_on_change_cb,
                              $widget->{'-onchange'} );
    $self->assert_str_equals( 'Test Value', $widget->{'-text'} );

    return;
}

sub test_on_change_cb {
    my $self = $_[0];

    my $win = $self->{'window'};
    my $widget = $win->add( 'test_widget', 'Lire::UI::StringWidget',
                            'value' => $self->{'string_value'} );
    my $or_value = $widget->text();
    $widget->text( 'New value' );
    Lire::UI::StringWidget::_on_change_cb( $widget );
    $self->assert_str_not_equals( $or_value, $self->{'string_value'}->get() );
    $self->assert_str_equals( 'New value', $self->{'string_value'}->get() );
}

sub test_refresh_view {
    my $self = $_[0];
    my $widget = $self->{'window'}->add( 'test_widget',
                                         'Lire::UI::StringWidget',
                                         'value' => $self->{'string_value'} );
    $self->{'string_value'}->set( 'A new value' );
    $widget->refresh_view();
    $self->assert_str_equals( 'A new value', $widget->text() );
}

1;
