package tests::XMLSpecContainerTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::Param;
use Lire::XMLSpecContainer;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();
    $self->init_i18n();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_locale();
    $self->set_up_test_schema();

    my $spec = new Lire::XMLSpecContainer();
    $spec->superservice( 'test' );
    $spec->param( 'bidon', new Lire::Param( 'name' => 'bidon',
                                            'type' => 'int',
                                            'default' => 5 ) );

    $self->{'xmlspec'} = $spec;

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_locale();

    return $self;
}

sub test_resolve_param_ref {
    my $self = $_[0];

    $self->assert_null( $self->{'xmlspec'}->resolve_param_ref(),
                        'expected undef' );
    $self->assert_equals( 4, $self->{'xmlspec'}->resolve_param_ref( 4 ));
    $self->assert_equals( 5, $self->{'xmlspec'}->resolve_param_ref('$bidon' ));
    $self->assert_died(sub {$self->{'xmlspec'}->resolve_param_ref( '$wawa' ) },
                       qr/no such parameter: 'wawa'/ );

}


sub test_title_i18n {
    my $self = $_[0];

    my $spec = $self->{'xmlspec'};
    $spec->{'title'} = 'JPEG Files';
    $self->assert_str_equals( 'JPEG Files', $spec->title() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( 'Fichiers JPEG', $spec->title() );
}

sub test_description_i18n {
    my $self = $_[0];

    my $spec = $self->{'xmlspec'};
    $spec->{'description'} = '<para>JPEG Files</para>';
    $self->assert_str_equals( '<para>JPEG Files</para>',
                              $spec->description() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( '<para>Fichiers JPEG</para>',
                              $spec->description() );
}

sub test_display_title_i18n {
    my $self = $_[0];

    my $spec = $self->{'xmlspec'};
    $spec->{'display_title'} = 'Downloads by File, Top $files_to_show';
    $self->assert_str_equals( 'Downloads by File, Top $files_to_show',
                              $spec->display_title() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( 'Transferts par fichiers, les $files_to_show les plus transfrs',
                              $spec->display_title() );
}

sub test_display_description_i18n {
    my $self = $_[0];

    my $spec = $self->{'xmlspec'};
    $spec->{'display_description'} = 'Downloads by File, Top $files_to_show';
    $self->assert_str_equals( 'Downloads by File, Top $files_to_show',
                              $spec->display_description() );
    $self->set_locale( 'fr_CA' );
    $self->assert_str_equals( 'Transferts par fichiers, les $files_to_show les plus transfrs',
                              $spec->display_description() );
}


1;
