package tests::functional::LrRunTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase/;

use Lire::Config::Build qw/ac_info/;

sub test_lr_run {
    my $self = $_[0];

    my $result = $self->lire_run( q{lr_run eval 'echo $prefix'} );
    $self->annotate( $result->stderr );
    $self->assert_equals( 0, $result->status );
    $self->assert_equals( ac_info( 'prefix' ) . "\n", $result->stdout );
    $self->assert( !$result->stderr, "stderr should be empty" );
}

1;
