package tests::helpers::TestDlfConverter;

use strict;

use base qw/Lire::DlfConverter/;

sub new {
    return bless {}, shift;
}

sub name {
    return "test_newapi";
}

sub title {
    return "New API DlfConverter";
}

sub description {
    return "<para>No description</para>";
}

sub schemas {
    return "test";
}

sub handle_log_lines { return 0 }

sub init_dlf_converter {}

sub process_log_file {
    my ( $self, $process, $fd ) = @_;

    my @fields = qw/time_start time_end time_taken connection_id client_host
                    user file file_size complete /;
    my $line;
    while ( defined( $line = <$fd> ) ) {
        chomp $line;
        my %dlf = ();
        my $i=0;
        foreach my $value ( split ' ', $line ) {
            $dlf{$fields[$i++]} = $value ne 'LIRE_NOTAVAIL' ? $value : undef;
        }
        if ( $i == @fields ) {
            $process->write_dlf( "test", \%dlf );
        } else {
            $process->error( $line, "Not a test DLF line" );
        }
    }
}

sub finish_conversion {}

1;
