<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LRML/" 
  exclude-result-prefixes="lire">

  <xsl:template match="/lire:report">
    <html>
      <head>
	<title>Lire <xsl:value-of select="lire:section/lire:subreport/@superservice"/> Report</title>
	<link rel="Stylesheet" rev="Stylesheet" href="report.css" type="text/css" />
      </head>

      <body>
	<h1>Lire <xsl:value-of select="lire:section/lire:subreport/@superservice"/> Report</h1>
		<p>
		<strong>Report generated:</strong> <xsl:value-of select="lire:date"/><br />
	  	<strong>Reporting on period:</strong> <xsl:value-of select="lire:timespan"/></p>
	

	<xsl:apply-templates select="lire:section"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="lire:section">
    <h2>
      <xsl:value-of select="lire:title"/>
    </h2>

    <xsl:if test="lire:description">
      <xsl:apply-templates select="lire:description"/>
    </xsl:if>

    <xsl:choose>
      <xsl:when test="lire:subreport">
	<xsl:apply-templates select="lire:subreport"/>
      </xsl:when>

      <xsl:otherwise>
	<p>No subreports were generated for this section.</p>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="lire:subreport">
    <h3 id="{generate-id(.)}">
      <xsl:value-of select="lire:title"/>
    </h3>
    <xsl:apply-templates select="lire:description"/>
    <xsl:apply-templates select="lire:image"/>
    <xsl:apply-templates select="lire:table"/>
  </xsl:template>


  <xsl:template match="lire:column-info">
    <xsl:variable name="label">
      <xsl:choose>
	<xsl:when test="@label">
	  <xsl:value-of select="@label"/>
	</xsl:when>
	<xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="col-span" select="(@col-end - @col-start) + 1"/>

    <th colspan="{$col-span}" class="{@class}"><xsl:value-of select="$label"/></th>
  </xsl:template>

  <xsl:template match="lire:table-info">
    <thead>
      <tr>
	<!-- In the first table header row, we want the labels
	of the first row categorical column, and all the
	numerical columns' label -->
	<xsl:variable name="cells" 
	  select="lire:column-info[@class = 'categorical']|.//lire:column-info[@class = 'numerical']"/>

	<xsl:call-template name="make.cells">
	  <xsl:with-param name="cells" select="$cells"/>
	  <xsl:with-param name="colinfos" select=".//lire:column-info"/>
	</xsl:call-template>
      </tr>
      <xsl:call-template name="make.other.header.row"/>
  </thead>
 </xsl:template>

 <!-- The context-node should be the table-info element -->
 <xsl:template name="make.other.header.row">
    <xsl:param name="row-idx" select="1"/>

    <!-- Select the group-info element which are at this row index -->
    <xsl:variable name="group-infos"
      select=".//lire:group-info[@row-idx = $row-idx]"/>

    <xsl:if test="count($group-infos)">
      <tr>
	<!-- We only process the categorical columns, the numerical 
	ones are in the first row -->
	<xsl:variable name="cells"
	  select="$group-infos/lire:column-info[@class = 'categorical']"/>

	<xsl:call-template name="make.cells">
	  <xsl:with-param name="cells" select="$cells"/>
	  <xsl:with-param name="colinfos" select=".//lire:column-info"/>
	</xsl:call-template>
      </tr>
   
      <!-- Try to make one more row -->
      <xsl:call-template name="make.other.header.row">
	<xsl:with-param name="row-idx" select="$row-idx + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template match="lire:group-summary">
  	<xsl:if test="lire:value">
  	<xsl:variable name="cells" select="lire:value"/>
    <tfoot>
      <tr>
		<table border="0" cellspacing="4" cellpadding="0">
			<tr>
			<td>Summary of <xsl:value-of select="@nrecords"/> records:</td>
			 <xsl:for-each select="lire:value">
			 	<td>
			 	<xsl:value-of select="@col"/>:
			 	<xsl:value-of select="."/>
			 	</td>
			 </xsl:for-each>
			</tr>
		</table>
	  </tr>
	</tfoot>
	</xsl:if>
  </xsl:template>

  <xsl:template match="lire:table">
    <xsl:variable name="columns" 
      select="count(lire:table-info//lire:column-info)"/>
    <xsl:choose>
      <xsl:when test="lire:entry">
	<table border="0" class="lireTable" cellspacing="0" cellpadding="4">
	  <xsl:apply-templates select="lire:table-info"/>
	  <tbody>
	    <xsl:call-template name="make.row"/>
	  </tbody>
	 <xsl:apply-templates select="lire:group-summary"/>
<!--
	      <xsl:apply-templates select="lire:group-summary"/>
-->
        </table>
      </xsl:when>
      
      <xsl:otherwise><p>No content in report.</p></xsl:otherwise>
      
    </xsl:choose>
  </xsl:template>

  <!-- Context node is lire:table. -->
  <xsl:template name="make.row">
    <xsl:param name="row-idx" select="0"/>
    
    <!-- Select the name and value element which are at this row index -->
    <xsl:variable name="entries"
      select=".//lire:entry[@row-idx = $row-idx]|.//lire:group-summary[@row-idx = $row-idx]"/>
    <xsl:if test="count($entries)">
      
      <xsl:variable name="rowClass">
	<xsl:call-template name="row.coloring"> 
	  <xsl:with-param name="row-idx" select="$row-idx"/>
	</xsl:call-template>
      </xsl:variable> 

      <xsl:variable name="cells" select="$entries/lire:name|$entries/lire:value"/>

      <tr class="{$rowClass}">
	<xsl:call-template name="make.cells">
	  <xsl:with-param name="cells" select="$cells"/>
	  <xsl:with-param name="colinfos" select="lire:table-info//lire:column-info"/>
	</xsl:call-template>
      </tr>
    	
      <!-- Try to make one more row -->
      <xsl:call-template name="make.row">
	<xsl:with-param name="row-idx" select="$row-idx + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="make.cells">
    <xsl:param name="cells"/>
    <xsl:param name="colinfos" select="lire:table-info//lire:column-info"/>
    <xsl:param name="cur.column" select="0"/>

    <xsl:variable name="ncols" select="count($colinfos)"/>

    <!-- Find the column-info which starts at the current column -->
    <xsl:variable name="start.col"
      select="$colinfos[@col-start = $cur.column]/@name"/>

    <!-- Try to find it in the cells parameter. 
    We test both for name or col since cells may be
    lire:column-info, lire:name or lire:value elements -->
    <xsl:variable name="start.cell"
      select="$cells[@name = $start.col or @col = $start.col]"/>

    <!-- Find the columns which spans the current cell  -->
    <xsl:variable name="spanning.cols"
      select="$colinfos[@col-start &lt;= $cur.column and 
		        @col-end &gt;= $cur.column ]/@name"/>

    <!-- 
    Check if we have one of those spanning column among the $cells
    parameter.

    NOTE: Equality betweeen node-set is defined as true when one 
    node in the other node-set has the same value than a node in the
    first node-set [XPATH: 3.4] -->
    <xsl:variable name="spanning.cells"
      select="$cells/@col = $spanning.cols or $cells/@name = $spanning.cols"/>

    <xsl:choose>
      <!-- $cells contained the cell starting at the current column  -->
      <xsl:when test="$start.cell">
	<xsl:apply-templates select="$start.cell">
		<xsl:with-param name="cur.column" select="$cur.column"/>
	</xsl:apply-templates>
      </xsl:when>

      <!-- $cells contained a least one cell which spans the current
      column -->
      <xsl:when test="$spanning.cells">
	<!-- Do nothing -->
      </xsl:when>

      <!-- Otherwise, we need an empty cell here -->
      <xsl:otherwise>
      <xsl:call-template name="make.empty.cell">
		<xsl:with-param name="cur.column" select="$cur.column"/>
		</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

    <!-- Process all column like this until we reach ncols -->
    <xsl:if test="($cur.column + 1) &lt; $ncols">
      <xsl:call-template name="make.cells">
	<xsl:with-param name="cells" select="$cells"/>
	<xsl:with-param name="colinfos" select="$colinfos"/>
	<xsl:with-param name="cur.column" select="$cur.column + 1"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <!-- This template matches the cells that are in the entry at the 
  top level of the table -->
  <xsl:template match="lire:name|lire:value">
    <!-- Find the column info associated with this one -->
    <xsl:variable name="colname" select="@col"/>
    <xsl:variable name="colinfo" 
      select="ancestor::lire:table/lire:table-info//lire:column-info[@name = $colname]"/>
    <xsl:variable name="col-span" select="$colinfo/@col-end - $colinfo/@col-start + 1"/>

    <td colspan="{$col-span}" class="column{$cur.column}"><span class="{$colinfo/@class}"><xsl:value-of select="normalize-space(.)"/></span></td>
  </xsl:template>

  <!-- This template matches the cells that are in a group -->
  <xsl:template match="lire:group//lire:name|lire:value">

    <!-- Find the column info associated with this one -->
    <xsl:variable name="colname" select="@col"/>
    <xsl:variable name="colinfo" 
      select="ancestor::lire:table/lire:table-info//lire:column-info[@name = $colname]"/>
    <xsl:variable name="col-span" select="$colinfo/@col-end - $colinfo/@col-start + 1"/>
    
    <xsl:variable name="nestlevel" select="count(ancestor::lire:group)"/>

    <td colspan="{$col-span}" class="column{$cur.column}"><span class="{$colinfo/@class}-nest{$nestlevel}"><xsl:value-of select="normalize-space(.)"/></span></td>
  </xsl:template>
  
  
  <xsl:template match="lire:description">
    <div> <!-- or whatever wrapper ends up being around the description -->
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="para">
    <p><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="quote">
    <strong><xsl:apply-templates/></strong>
  </xsl:template>

  <xsl:template name="row.coloring">
    <xsl:param name="row-idx" select="0"/>
    <xsl:choose>
      <xsl:when test="$row-idx mod 2 &gt; 0">
	<xsl:value-of select="'oddRow'"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'evenRow'"/>
      </xsl:otherwise>
    </xsl:choose>   
  </xsl:template>

  <xsl:template name="make.empty.cell">
    <xsl:param name="colspan" select="1"/>
    
    <td colspan="{$colspan}" class="column{$cur.column}"> </td>
  </xsl:template>

</xsl:stylesheet> 

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
