<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lire="http://www.logreport.org/LDSML/"
  exclude-result-prefixes="lire">

  <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>

  <xsl:param name="superservice" select="unknown"/>
  <xsl:param name="specdir"	 select="'.'"/>
  <xsl:param name="spec-files"   select="''"/>

  <!-- Receives the list of XML specification spec-files parameter -->
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="contains($spec-files, ' ')">
	<xsl:call-template name="gen.schema.section">
	  <xsl:with-param name="spec-files" select="normalize-space($spec-files)"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:message terminate="yes">No DLF schemas specified in the
	  'spec-files' parameter.</xsl:message>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="find.schema">
    <xsl:param name="files"/>
    <xsl:param name="type"/>
    <xsl:param name="found" select="''"/>

    <xsl:variable name="filename">
      <xsl:choose>
	<xsl:when test="contains( $files, ' ' )">
	  <xsl:value-of select="substring-before( $files, ' ' )"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$files"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="file" select="concat( $specdir, '/', $filename)"/>

    <xsl:variable name="rest">
      <xsl:value-of select="substring-after( $files, ' ' )"/>
    </xsl:variable>

    <xsl:variable name="new-found">
      <xsl:choose>
	<xsl:when test="document($file)/*[local-name() = $type]">
	  <xsl:choose>
	    <xsl:when test="string-length( $found )">
	      <xsl:value-of select="concat( $found, ' ', $filename )"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="$filename"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$found"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:choose>
      <!-- Recurse -->
      <xsl:when test="string-length($rest)">
	<xsl:call-template name="find.schema">
	  <xsl:with-param name="files" select="$rest"/>
	  <xsl:with-param name="type" select="$type"/>
	  <xsl:with-param name="found" select="$new-found"/>
	</xsl:call-template>
      </xsl:when>
      <!-- Last file -->
      <xsl:otherwise>
	<xsl:value-of select="$new-found"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="process.documents">
    <xsl:param name="files"/>

    <xsl:variable name="filename">
      <xsl:choose>
	<xsl:when test="contains( $files, ' ' )">
	  <xsl:value-of select="substring-before( $files, ' ' )"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$files"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="file" select="concat( $specdir, '/', $filename)"/>

    <xsl:variable name="rest">
      <xsl:value-of select="substring-after( $files, ' ' )"/>
    </xsl:variable>

    <xsl:apply-templates select="document($file)/*"/>

    <xsl:if test="string-length( $rest )">
      <!-- Recurse if there are other files -->
      <xsl:call-template name="process.documents">
	<xsl:with-param name="files" select="$rest"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="make.field.list">
    <xsl:param name="fields"/>

    <xsl:variable name="field">
      <xsl:choose>
	<xsl:when test="contains( $fields, ' ' )">
	  <xsl:value-of select="substring-before( $fields, ' ' )"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$fields"/>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="rest" select="substring-after( $fields, ' ' )"/>

    <xsl:choose>
      <xsl:when test="string-length( $field)">
	<link linkend="{$superservice}.{$field}.field.ref"><xsl:value-of 
	    select="$field"/></link>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="'None'"/>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:if test="string-length( $rest )">
      <!-- Recurse -->
      <xsl:value-of select="', '"/>
      <xsl:call-template name="make.field.list">
	<xsl:with-param name="fields" select="$rest"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="gen.schema.section">
    <xsl:param name="spec-files"/>

    <xsl:variable name="base-schema">
      <xsl:call-template name="find.schema">
	<xsl:with-param name="files" select="$spec-files"/>
	<xsl:with-param name="type" select="'dlf-schema'"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:if test="contains( $base-schema, ' ' )">
      <xsl:message terminate="yes">
	Multiple dlf-schemas found. Aborting.
      </xsl:message>
    </xsl:if>

    <xsl:variable name="extended-schemas">
      <xsl:call-template name="find.schema">
	<xsl:with-param name="files" select="$spec-files"/>
	<xsl:with-param name="type" select="'extended-schema'"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="derived-schemas">
      <xsl:call-template name="find.schema">
	<xsl:with-param name="files" select="$spec-files"/>
	<xsl:with-param name="type" select="'derived-schema'"/>
      </xsl:call-template>
    </xsl:variable>

    <section id="sect:{$superservice}.schemas.ref">
      <title>Schemas for the <type><xsl:value-of select="$superservice"/></type>
	Superservice</title>
	
      <xsl:call-template name="process.documents">
	<xsl:with-param name="files" select="$base-schema"/>
      </xsl:call-template>

      <xsl:if test="string-length( $extended-schemas )">
	<section id="sect:{$superservice}.extended-schema.ref">
	  <title>Extended Schemas for the
	    <type><xsl:value-of select="$superservice"/></type>
	    Superservice</title>
	  
	  <xsl:call-template name="process.documents">
	    <xsl:with-param name="files" select="$extended-schemas"/>
	  </xsl:call-template>
	</section>
      </xsl:if>
      
      <xsl:if test="string-length( $derived-schemas )">
	<section id="sect:{$superservice}.derived-schema.ref">
	  <title>Derived Schemas for the
	    <type><xsl:value-of select="$superservice"/></type>
	    Superservice</title>
	  
	  <xsl:call-template name="process.documents">
	    <xsl:with-param name="files" select="$derived-schemas"/>
	  </xsl:call-template>
	</section>
      </xsl:if>
    </section>

  </xsl:template>

  <xsl:template match="lire:dlf-schema">
    <section id="sect:{$superservice}.schema.ref">
      <title><xsl:value-of select="lire:title"/></title>

      <!-- Id, chart, desc, params -->
      <segmentedlist>
	<segtitle>Schema ID</segtitle>
	<segtitle>Timestamp Field</segtitle>
	<seglistitem>
	  <seg><constant><xsl:value-of select="@superservice"/></constant></seg>
	  <seg><constant><xsl:value-of select="@timestamp"/></constant></seg>
	</seglistitem>
      </segmentedlist>

      <xsl:apply-templates select="lire:description"/>

      <variablelist>
	<title>Fields in the Schema</title>
	<xsl:apply-templates select="lire:field"/>
      </variablelist>
    </section>
  </xsl:template>

  <xsl:template match="lire:extended-schema|lire:derived-schema">

    <section id="sect:{@id}.schema.ref">
      <title><xsl:value-of select="lire:title"/></title>

      <!-- Id, chart, desc, params -->
      <segmentedlist>
	<segtitle>Schema ID</segtitle>
	<segtitle>Base Schema</segtitle>
	<segtitle>Module</segtitle>
	<segtitle>Required Fields</segtitle>
	<xsl:if test="local-name() = 'derived-schema'">
	<segtitle>Timestamp Field</segtitle>
	</xsl:if>
	<seglistitem>
	  <seg><constant><xsl:value-of select="@id"/></constant></seg>
	  <seg><link linkend="sect:{@base-schema}.schema.ref"><constant><xsl:value-of select="@base-schema"/></constant></link></seg>
	  <seg><classname><xsl:value-of
		select="@module"/></classname></seg>
	  <seg><xsl:call-template name="make.field.list">
	      <xsl:with-param name="fields" select="@required-fields"/>
	    </xsl:call-template>
	  </seg>
	  <xsl:if test="local-name() = 'derived-schema'">
	  <seg><link linkend="{$superservice}.{@timestamp}.field.ref"><constant><xsl:value-of select="@timestamp"/></constant></link></seg>
	  </xsl:if>
	</seglistitem>
      </segmentedlist>

      <xsl:apply-templates select="lire:description"/>

      <variablelist>
	<title>Fields in the Schema</title>
	<xsl:apply-templates select="lire:field"/>
      </variablelist>
    </section>
  </xsl:template>

  <xsl:template match="lire:description">
    <xsl:copy-of select="*"/>
  </xsl:template>

  <xsl:template match="lire:field">

    <xsl:variable name="default">
      <xsl:choose>
	<xsl:when test="string-length(@default)">
	  <xsl:value-of select="@default"/>
	</xsl:when>

	<xsl:otherwise>
	  <!-- Determine default based on type -->
	  <xsl:choose>
	    <xsl:when test="contains( 'bytes int number duration timestamp time date ',
	      concat( ' ', @type, ' ' ))">
	      <xsl:value-of select="'0'"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="'-'"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <varlistentry>
      <term id="{$superservice}.{@name}.field.ref"><structfield><xsl:value-of select="@name"/></structfield></term>
      <listitem>
	<segmentedlist>
	  <segtitle>Type</segtitle>
	  <segtitle>Defaults</segtitle>
	  <seglistitem>
	    <seg><xsl:value-of select="@type"/></seg>
	    <seg><xsl:value-of select="$default"/></seg>
	  </seglistitem>
	</segmentedlist>
	<xsl:apply-templates select="lire:description"/>
      </listitem>
    </varlistentry>
  </xsl:template>

</xsl:stylesheet>

<!-- 
Keep this comment at the end of the file
Local variables:
mode: xml
sgml-indent-step: 2
End:
-->
