## $Id: rules.mk,v 1.67 2004/04/09 20:01:52 flacoste Exp $

## Copyright (C) 2000-2001 Stichting LogReport Foundation LogReport@LogReport.org
## 
##     This program is free software; you can redistribute it and/or modify
##     it under the terms of the GNU General Public License as published by
##     the Free Software Foundation; either version 2 of the License, or
##     (at your option) any later version.
## 
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     GNU General Public License for more details.
## 
##     You should have received a copy of the GNU General Public License
##     along with this program (see COPYING); if not, check with
##     http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
##     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

## jade's -E flag. default is 200, we don't want to scroll the first and most
## interesting error off our screen though.
MAX_JADE_ERRORS=10

## used in superservice/script/Makefile.am, via convertors_SCRIPTS
convertorsdir = $(libexecdir)/$(PACKAGE)/convertors

XML_DCL=$(top_srcdir)/all/lib/xml/xml.dcl

## Old suffix rules are portable between GNU make 
## and non GNU make
SUFFIXES = .pod .1 .7 .pm .3pm .dbx .xml .dia .eps .in

## beware: the Config module has a .in suffix

.pm.3pm:
	$(PERL2MAN_RULE)

.pod.1:
	$(PERL2MAN_RULE)

## fixme: should make sure it doesn't say LIRE(1) in header, but LIRE(7)
.pod.7:
	$(PERL2MAN_RULE)

.in.1:
	$(PERL2MAN_RULE)

.dia.eps:
	$(DIA2EPS_RULE)

.dia.png:
	$(DIA2PNG_RULE)

# This is still an unsettle issue. 
#.dbx.1:
#	$(XML2MAN_RULE)

##
## there are different "solutions" on how to create man files for perl modules,
## containing :: in the filename.
## take a look at gelfand:/usr/local/src/MailTools/MailTools-1.15/Makefile 's 
## manifypods target.
## or see Message-ID: <14876.5087.303743.313283@lemming.engeast.baynetworks.com>
## on the GNU help-make mailing list.
##
## we can't use $< here to indicate the dependency, since some makes (e.g.
## /usr/ccs/bin/make as shipped with sparc-sun-solaris2.7) don't grok that.
## duh.
##
## we can't use pod2man's --name: its not supported in Perl 5.00503's pod2man
## (seems to be a 5.8.0 thing)
##PERL2MAN_RULE = \
## 	name=`echo $? | perl -ne '$$_ =~ s/\.in$$//; $$_ =~ s/\.pod$$//; tr/a-z/A-Z/; print'`; pod2man --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' --name="$$name" $? > $@
##
## we should run podchecker(1) too, once we require a more recent perl

PERL2MAN_RULE = \
	$(POD2MAN) --center="LogReport's Lire Documentation" --release='Lire $(VERSION)' $? > $@

# uses the docbook-to-man program. Debian: see docbook-to-man package.
# XML2MAN_RULE = for f in $(docbooks); \
#  do \
#   man="`echo $$f | sed 's/\..*$$//'`.$(section)"; \
#   docbook2manxml $$f | man_xml > $$man; \
#  done

# restored to use docbook2man: don't feel like searching for and installing
# new dcbk tools now.  JvB
XML2MAN_RULE = \
	docbook2man $< > $@

XML2HTML_RULE = \
	mysrc=`cd $(srcdir) && pwd`; \
	mytop=`cd $(top_srcdir) && pwd`; \
	outdir=`dirname $@`; \
	src=$$mysrc/`basename $<`; \
	$(mkinstalldirs) $$outdir && \
	cd $$outdir && \
	rm -f *.htm* && \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	for i in $$epss; do \
	    png=`basename $$i .eps`.png; \
	    $(PERL) $(top_builddir)/all/script/lr_gsconvert --resize=576,576 pngalpha $$i $$png; \
	done; \
	XML_CATALOG_FILES=$$mytop/catalog.xml $(XSLTPROC) --nonet --param 'graphic.default.extension' '"png"' $(DBKXSLHTML) $$src

HTML2TXT_RULE = \
XML_CATALOG_FILES=$(top_srcdir)/catalog.xml $(XSLTPROC) --nonet $(DBKXSLHTMLNOCHUNK) $< > tmp.html && \
$(LYNX) -nolist -dump tmp.html > $@ && \
rm tmp.html

## we need to run pdfjadetex three times gets pagenumbers in toc right
XML2PDF_RULE = \
	base=`basename $@ .pdf`; \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	pdfs=""; \
	for i in $$epss; do \
	    pdf=`basename $$i .eps`.pdf; \
	    $(PERL) $(top_builddir)/all/script/lr_gsconvert --resize=396,396 pdfwrite $$i $$pdf; \
	    pdfs="$$pdfs $$pdf"; \
	done; \
	$(JADE) -E$(MAX_JADE_ERRORS) -t tex -d $(DBKDSSSLPRINT) $(XML_DCL) $< && \
	i=0; \
	while test $$i -lt 3; do \
	    if $(PDFJADETEX) -interaction=batchmode $$base.tex > /dev/null; \
	    then \
		if grep 'undefined references\| [Rr]erun' $$base.log > /dev/null; \
		then  :;  else break; fi; \
	    else \
		grep '^! ' $$base.log; \
		exit 1; \
	    fi; \
        i=`expr $$i + 1`; \
	done; \
	rm -f $$base.log $$base.out $$base.aux $$base.tex $$pdfs

XML2PDF_FO_RULE = \
	mysrc=`cd $(srcdir) && pwd`; \
	mytop=`cd $(top_srcdir) && pwd`; \
	src=$$mysrc/`basename $<`; \
	base=`basename $@ .pdf`; \
	epss=`for i in $^; do echo $$i; done | grep '\.eps$$'`; \
	pdfs=""; \
	for i in $$epss; do \
	    pdf=`basename $$i .eps`.pdf; \
	    $(PERL) $(top_builddir)/all/script/lr_gsconvert --resize=396,396 pdfwrite $$i $$pdf; \
	    pdfs="$$pdfs $$pdf"; \
	done; \
	XML_CATALOG_FILES=$$mytop/catalog.xml $(XSLTPROC) --nonet --param 'graphic.default.extension' '"pdf"' $(DBKXSLFO) $$src > $$base.fo; \
	i=0; \
	while test $$i -lt 3; do \
	    if $(PDFXMLTEX) -interaction=batchmode $$base.fo; \
	    then \
		if grep 'undefined references\| [Rr]erun' $$base.log > /dev/null; \
		then  :;  else break; fi; \
	    else \
		grep '^! ' $$base.log; \
		exit 1; \
	    fi; \
        i=`expr $$i + 1`; \
	done; \
	rm -f $$base.log $$base.out $$base.aux $$base.tex $$pdfs

REPORTS_INFOS_RULE = \
XML_CATALOG_FILES=$(top_srcdir)/catalog.xml $(XSLTPROC) --nonet --param 'superservice' "'$(superservice)'" --param 'spec-files' "'$^'" --param 'specdir'  "'`pwd`'" $(top_srcdir)/all/lib/xml/stylesheet/xsl/convert_reportspec2docbook.xsl $<  > $@ || ( rm $@ && exit 1 )

SCHEMAS_DOC_RULE = \
XML_CATALOG_FILES=$(top_srcdir)/catalog.xml $(XSLTPROC) --nonet --param 'superservice' "'$(superservice)'" --param "spec-files" "'$^'" --param "specdir" "'`pwd`'" $(top_srcdir)/all/lib/xml/stylesheet/xsl/make-schema-doc.xsl $<  > $@ || ( rm $@ && exit 1 )

DIA2EPS_RULE = \
	$(DIA) --nosplash -e $@ $<

DIA2PNG_RULE = \
	$(DIA) --nosplash -e $@ $<

## Make sure that the first rule is all
all: all-redirect

check-local: check-xml

# We have to work with the fact that xmllint doesn't
# give an error when validation fails. It exits with
# non-zero status only when the file isn't well-formed

# We have to test for either srcdir/$f or $f : lire.xml
# exists in . only.
#
check-xml: $(XML_FILES)
	@if test -z "$(XML_FILES)"; \
	then \
	    echo No XML files to validate; \
	else \
	    for f in $(XML_FILES); \
	    do \
		echo -n Checking $$f...; \
                test -f $(srcdir)/$$f && file=$(srcdir)/$$f || file=$$f; \
		SGML_CATALOG_FILES="$(top_builddir)/catalog:$(top_srcdir)/all/lib/xml/dtd/catalog" $(XMLLINT) --catalogs --noout --valid $$file 2> xmllint.error; \
		if test -s xmllint.error; \
		then \
		    echo failed; \
		    cat xmllint.error; \
		    rm -f xmllint.error; \
		    exit 1; \
		else \
		    echo ok; \
		    rm -f xmllint.error; \
		fi; \
	    done; \
	fi

