package tests::ConfigReportConfigIndexTest;

use base qw/Lire::Test::TestCase/;

use Lire::Config::TypeSpec;
use Lire::Config::Index;
use Lire::Config::ReportConfigIndex;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    my $spec = new Lire::Config::ListSpec( 'name' => 'reports' );
    $spec->add( new Lire::Config::ReportSpec( 'name' => 'report' ) );

    $self->{'reports_list'} = $spec->instance();
    $self->{'reports_list'}->append( $spec->get( 'report' )->instance() );
    $self->{'reports_list'}->append( $spec->get( 'report' )->instance() );

    $self->{'reports_list'}->get( 0 )->get( 'id' )->set( 'test1' );
    $self->{'reports_list'}->get( 1 )->get( 'id' )->set( 'test2' );

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_new {
    my $self = $_[0];

    $self->assert_dies( qr/'list' spec should contain only one Lire::Config::ReportSpec component/,
                        sub { new Lire::Config::ReportConfigIndex( new Lire::Config::ListSpec( 'name' => 'test' )->instance() ) } );

    my $index = new Lire::Config::ReportConfigIndex( $self->{'reports_list'} );
    $self->assert_isa( 'Lire::Config::ReportConfigIndex', $index );
    $self->assert_str_equals( $self->{'reports_list'},
                              $index->{'_list'} );
}

sub test_has_entry {
    my $self = $_[0];

    my $index = new Lire::Config::ReportConfigIndex( $self->{'reports_list'} );
    $self->assert( $index->has_entry( 'test1' ) ? 1 : 0, 'test1' );
    $self->assert( $index->has_entry( 'test2' ) ? 1 : 0, 'test2' );
    $self->assert( !$index->has_entry( 'test3' ) ? 1 : 0, 'test3' );
}

sub test_entries {
    my $self = $_[0];

    my $index = new Lire::Config::ReportConfigIndex( $self->{'reports_list'} );
    $self->assert_deep_equals( [ 'test1', 'test2' ], $index->entries() );

}

sub test_get_ref {
    my $self = $_[0];

    my $index = new Lire::Config::ReportConfigIndex( $self->{'reports_list'} );
    $self->assert_dies( qr/no report configuration "test3"/,
                        sub { $index->get_ref( 'test3' ) } );
    $self->assert_isa( 'Lire::ReportConfig', $index->get_ref( 'test1' ) );
}

1;
