package tests::SheetsCategoriserTest;

use base qw/Lire::Test::DlfAnalyserTestCase/;

use Lire::DlfAnalysers::SheetsCategoriser;
use File::Basename;

sub schemasdir {
    return dirname( __FILE__ ) . "/../..";
}

sub create_analyser {
    return new Lire::DlfAnalysers::SheetsCategoriser();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../../sheets_init";
}

sub test_categorise {
    my $self = $_[0];

    my $analyser = $self->create_analyser();

    my $dlf = { 'num_copies' => undef,
                'num_pages' => undef,
              };
    $analyser->categorise( $dlf );
    $self->assert_null( $dlf->{'num_sheets'} );

    $dlf->{'num_pages'} = 10;
    $analyser->categorise( $dlf );
    $self->assert_num_equals( 10, $dlf->{'num_sheets'} );

    $dlf->{'num_copies'} = 3;
    $analyser->categorise( $dlf );
    $self->assert_num_equals( 30, $dlf->{'num_sheets'} );

    return;
}


1;
