/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.model.LisaacCompletionParser;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.templates.LisaacTemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LisaacCompletionProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private LisaacTemplateProcessor templates;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        block7: {
            boolean enableCompletion = LisaacPlugin.getDefault().getPreferenceStore().getBoolean("lisaac_competion");
            if (enableCompletion) break block7;
            return null;
        }
        try {
            String prefix;
            IDocument document = viewer.getDocument();
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            this.computeLisaacCompletion(document, offset, result);
            if (result.size() > 1) {
                Collections.sort(result, new Comparator<ICompletionProposal>(){

                    @Override
                    public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                        return o1.getDisplayString().compareTo(o2.getDisplayString());
                    }
                });
            }
            if ((prefix = this.extractPrefix(document, offset)) != null && prefix.length() > 0) {
                this.templates = new LisaacTemplateProcessor();
                ICompletionProposal[] props = this.templates.computeCompletionProposals(viewer, offset);
                int t = 0;
                while (t < props.length) {
                    TemplateProposal tp = (TemplateProposal)props[t];
                    if (tp.getDisplayString().startsWith(prefix)) {
                        result.add(props[t]);
                    }
                    ++t;
                }
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception exception) {
            return this.NO_COMPLETIONS;
        }
    }

    private void computeLisaacCompletion(IDocument document, int baseOffset, ArrayList<ICompletionProposal> proposals) {
        int bracketLevel = 0;
        try {
            int pos = baseOffset - 1;
            while (pos > 0) {
                char c = document.getChar(pos);
                if (c == ';' || c == ':' || c == '-' && pos - 1 > 0 && document.getChar(pos - 1) == '<' || LisaacParser.isOperatorSymbol(c)) break;
                if (c == '(' || c == '{' || c == '[') {
                    if (bracketLevel == 0) break;
                    --bracketLevel;
                }
                if (c == ')' || c == '}' || c == ']') {
                    ++bracketLevel;
                }
                --pos;
            }
            if (pos > 0) {
                String contents = document.get(pos + 1, baseOffset - 1 - pos);
                LisaacCompletionParser parser = new LisaacCompletionParser(contents, null);
                parser.parseCompletions(pos + 1, baseOffset, proposals);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(IDocument document, int offset) {
        i = offset;
        if (i <= document.getLength()) ** GOTO lbl6
        return "";
        {
            while (Character.isJavaIdentifierPart(ch = document.getChar(i - 1))) {
                --i;
lbl6:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "Lisaac Completion error";
    }
}

