/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */
 
 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/environment.h"

static void test_save (xmlDoc *doc, char *filename)
{
	xmlSaveFile (filename, doc);
}

static gboolean test_process (LWProject *project, xmlNode *node)
{
	LWProgram *program = new LWProgram ();
	
	if (FALSE == program->parse (project->getProgram()))
		return FALSE;
	
	program->setWorld (project->getWorld());
//	gtk_widget_hide(program->getWorld()->getWidget());
	
	program->execute();
	program->getWorld()->storeToXML (node);
	
	delete program;
	return TRUE;
}

int
main (int argc, char *argv[])
{
	gtk_init (&argc, &argv);

	LWEnvironment::init();
	LWProject *project = new LWProject();
	LWEnvironment::setProject (project);
	
	if (argc == 0) {
		g_print (" === Little Wizard Test Tool ===\n");
		g_print (" ===== (C) Marcin Kwadrans  ====\n");
		g_print (" =========== v 0.0.1 ===========\n\n");
		g_print ("Syntax:\n");
		g_print ("         lwtest program [output]\n");
		return 0;
	}
	
	if (argc > 1)
		project->load (argv[1]);

    xmlDoc *test_doc = xmlNewDoc(BAD_CAST "1.0");
    xmlNode *test_node = xmlNewNode(NULL, BAD_CAST "LittleWizardOutput");
	gboolean r = test_process (project, test_node);
    xmlDocSetRootElement(test_doc, test_node);

	if (r == TRUE)
		test_save (test_doc, (argc > 2) ? argv[2] : (char *) "-");
	
	xmlFreeDoc (test_doc);
	
	LWEnvironment::uninit();	

	return (r == TRUE) ? 0 : 1;
}
