/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file value.h
	\brief Zarządzanie wartościami
*/

#ifndef __LW_VALUE_H
#define __LW_VALUE_H

#include "pixmap.h"

/*! \class LWValue
	\brief Zarządzanie wartościami

	Klasa reprezentująca wartości argumentów poleceń
*/

class LWValue {
protected:
gboolean is_list;	
union {
LWPixmap *pixmap;
GSList *list;
};
void convertToList();
virtual gboolean isSpecial();
public:
LWValue ();
LWValue (LWPixmap *pixmap);
LWValue (gint ivalue);
LWValue (const LWValue *value);
virtual ~LWValue ();
virtual void clear ();
virtual void append (LWPixmap *pixmap);
virtual void concat (LWValue *value);
virtual gint toInt ();
virtual gboolean canBeIndexed ();
virtual LWValue *getIndex (guint n);
virtual GSList *getListPixmap ();
virtual LWPixmap *getPixmap ();
virtual void set (LWValue *value);
virtual LWValue *get ();
virtual guint count ();
virtual gboolean isVariable ();
};

#endif
