//===-- InstrScheduling.h - Interface To Instruction Scheduling -*- C++ -*-===//
// 
//                     The LLVM Compiler Infrastructure
//
// This file was developed by the LLVM research group and is distributed under
// the University of Illinois Open Source License. See LICENSE.TXT for details.
// 
//===----------------------------------------------------------------------===//
//
// This file defines a minimal, but complete, interface to instruction
// scheduling.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_CODEGEN_INSTR_SCHEDULING_H
#define LLVM_CODEGEN_INSTR_SCHEDULING_H

namespace llvm {

class FunctionPass;
class TargetMachine;

//---------------------------------------------------------------------------
// Function: createScheduleInstructionsWithSSAPass(..)
// 
// Purpose:
//   Entry point for instruction scheduling on SSA form.
//   Schedules the machine instructions generated by instruction selection.
//   Assumes that register allocation has not been done, i.e., operands
//   are still in SSA form.
//---------------------------------------------------------------------------

FunctionPass *createInstructionSchedulingWithSSAPass(const TargetMachine &TM);

} // End llvm namespace

#endif
