//===-- MSSchedule.h - Schedule ------- -------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file was developed by the LLVM research group and is distributed under
// the University of Illinois Open Source License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// The schedule generated by a scheduling algorithm
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_MSSCHEDULE_H
#define LLVM_MSSCHEDULE_H

#include "MSchedGraph.h"
#include <vector>

namespace llvm {

  class MSSchedule {
    std::map<int, std::vector<MSchedGraphNode*> > schedule;
    unsigned numIssue;
    
    //Internal map to keep track of explicit resources
    std::map<int, std::map<int, int> > resourceNumPerCycle;

    //Check if all resources are free
    bool resourcesFree(MSchedGraphNode*, int);

    //Resulting kernel
    std::vector<std::pair<MSchedGraphNode*, int> > kernel;

    //Max stage count
    int maxStage;

    //add at the right spot in the schedule
    void addToSchedule(int, MSchedGraphNode*);

  public:
    MSSchedule(int num) : numIssue(num) {}
    MSSchedule() : numIssue(4) {}
    bool insert(MSchedGraphNode *node, int cycle);
    int getStartCycle(MSchedGraphNode *node);
    void clear() { schedule.clear(); resourceNumPerCycle.clear(); kernel.clear(); }
    std::vector<std::pair<MSchedGraphNode*, int> >* getKernel() { return &kernel; }
    bool constructKernel(int II);
    int getMaxStage() { return maxStage; }

   
    //iterators
    typedef std::map<int, std::vector<MSchedGraphNode*> >::iterator schedule_iterator;
    typedef std::map<int, std::vector<MSchedGraphNode*> >::const_iterator schedule_const_iterator;
    schedule_iterator begin() { return schedule.begin(); };
    schedule_iterator end() { return schedule.end(); };
    void print(std::ostream &os) const;

    typedef std::vector<std::pair<MSchedGraphNode*, int> >::iterator kernel_iterator;
    typedef std::vector<std::pair<MSchedGraphNode*, int> >::const_iterator kernel_const_iterator;
    kernel_iterator kernel_begin() { return kernel.begin(); }
    kernel_iterator kernel_end() { return kernel.end(); }
    
  };

}


#endif
