//===-- SparcV9CodeEmitter.h ------------------------------------*- C++ -*-===//
// 
//                     The LLVM Compiler Infrastructure
//
// This file was developed by the LLVM research group and is distributed under
// the University of Illinois Open Source License. See LICENSE.TXT for details.
// 
//===----------------------------------------------------------------------===//
// 
// Target-specific portions of the machine code emitter for the SparcV9.
// This class interfaces with the JIT's Emitter in order to turn MachineInstrs
// into words of binary machine code. Its code is partially generated by
// TableGen's CodeEmitterGenerator.
//
//===----------------------------------------------------------------------===//

#ifndef SPARCV9CODEEMITTER_H
#define SPARCV9CODEEMITTER_H

#include "llvm/BasicBlock.h"
#include "llvm/CodeGen/MachineCodeEmitter.h"
#include "llvm/CodeGen/MachineFunctionPass.h"
#include "llvm/Target/TargetMachine.h"

namespace llvm {

class GlobalValue;
class MachineInstr;
class MachineOperand;

class SparcV9CodeEmitter : public MachineFunctionPass {
  TargetMachine &TM;
  MachineCodeEmitter &MCE;
  const BasicBlock *currBB;

  // Tracks which instruction references which BasicBlock
  std::vector<std::pair<const BasicBlock*,
                        std::pair<unsigned*,MachineInstr*> > > BBRefs;
  // Tracks where each BasicBlock starts
  std::map<const BasicBlock*, long> BBLocations;

public:
  SparcV9CodeEmitter(TargetMachine &T, MachineCodeEmitter &M);
  ~SparcV9CodeEmitter() {}

  const char *getPassName() const { return "SparcV9 Machine Code Emitter"; }

  /// runOnMachineFunction - emits the given machine function to memory.
  ///
  bool runOnMachineFunction(MachineFunction &F);

  /// emitWord - writes out the given 32-bit value to memory at the current PC.
  ///
  void emitWord(unsigned Val);
    
  /// getBinaryCodeForInstr - This function, generated by the
  /// CodeEmitterGenerator using TableGen, produces the binary encoding for
  /// machine instructions.
  ///
  unsigned getBinaryCodeForInstr(MachineInstr &MI);

private:    
  /// getMachineOpValue - 
  ///
  int64_t getMachineOpValue(MachineInstr &MI, MachineOperand &MO);

  /// emitBasicBlock - 
  ///
  void emitBasicBlock(MachineBasicBlock &MBB);

  /// getValueBit - 
  ///
  unsigned getValueBit(int64_t Val, unsigned bit);

  /// getGlobalAddress - 
  ///
  void* getGlobalAddress(GlobalValue *V, MachineInstr &MI,
                         bool isPCRelative);
  /// emitFarCall - 
  ///
  unsigned getRealRegNum(unsigned fakeReg, MachineInstr &MI);

};

} // End llvm namespace

#endif
