#ifndef SINGLE_SOURCE_COMPILE

/*
 * group_box.cpp - groupbox for LMMS
 *
 * Copyright (c) 2005-2007 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 * 
 * This file is part of Linux MultiMedia Studio - http://lmms.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */


#include "qt3support.h"

#ifdef QT4

#include <QtCore/QTimer>
#include <QtGui/QPainter>
#include <QtGui/QMouseEvent>

#else

#include <qpainter.h>
#include <qtimer.h>
#include <qobjectlist.h>

#endif

#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif

#include <math.h>


#include "group_box.h"
#include "embed.h"
#include "spc_bg_hndl_widget.h"
#include "gui_templates.h"


QPixmap * groupBox::s_ledBg = NULL;


groupBox::groupBox( const QString & _caption, QWidget * _parent,
							track * _track ) :
	QWidget( _parent ),
	m_caption( _caption ),
	m_origHeight( height() ),
	m_animating( FALSE )
{
#ifndef QT3
	setAutoFillBackground( TRUE );
#endif

	if( s_ledBg == NULL )
	{
		s_ledBg = new QPixmap( embed::getIconPixmap(
							"groupbox_led_bg" ) );
	}

	updatePixmap();

	m_led = new pixmapButton( this, _caption, _track );
	m_led->setCheckable( TRUE );
	m_led->move( 2, 3 );
	m_led->setActiveGraphic( embed::getIconPixmap( "led_green" ) );
	m_led->setInactiveGraphic( embed::getIconPixmap( "led_off" ) );
	m_led->setBgGraphic( specialBgHandlingWidget::getBackground( m_led ) );
	connect( m_led, SIGNAL( toggled( bool ) ),
					this, SLOT( setState( bool ) ) );
}




groupBox::~groupBox()
{
}




void groupBox::resizeEvent( QResizeEvent * )
{
	updatePixmap();
	if( m_animating == FALSE )
	{
		m_origHeight = height();
	}
}




void groupBox::mousePressEvent( QMouseEvent * _me )
{
	if( _me->y() > 1 && _me->y() < 13 )
	{
		setState( !isActive(), TRUE );
	}
}




void groupBox::setState( bool _on, bool _anim )
{
	m_led->setChecked( _on );
	if( ( _anim == TRUE || ( _on == TRUE && height() < m_origHeight ) ) &&
							m_animating == FALSE )
	{
		m_animating = TRUE;
		animate();
	}
	emit( toggled( _on ) );
}




void groupBox::animate( void )
{
	float state = (float)( m_origHeight - height() ) /
						(float)( m_origHeight - 19 );
	int dy = static_cast<int>( 3 - 2 * cosf( state * 2 * M_PI ) );
	if( isActive() && height() < m_origHeight )
	{
	}
	else if( !isActive() && height() > 19 )
	{
		dy = -dy;
	}
	else
	{
		m_animating = FALSE;
		return;
	}
	resize( width(), height() + dy );
	QTimer::singleShot( 10, this, SLOT( animate() ) );
#ifdef QT4
	QObjectList ch = parent()->children();
#else
	QObjectList ch = *( parent()->children() );
#endif
	for( csize i = 0; i < ch.count(); ++i )
	{
		QWidget * w = dynamic_cast<QWidget *>( ch.at( i ) );
		if( w == NULL || w->y() < y() + height() )
		{
			continue;
		}
		w->move( w->x(), w->y() + dy );
	}
#ifdef QT4
	ch = children();
#else
	ch = *children();
#endif
	for( csize i = 0; i < ch.count(); ++i )
	{
		QWidget * w = dynamic_cast<QWidget *>( ch.at( i ) );
		if( w == NULL || w == m_led )
		{
			continue;
		}
		w->move( w->x(), w->y() + dy );
		if( w->y() < 14)
		{
			w->hide();
		}
		else if( w->isHidden() == TRUE )
		{
			w->show();
		}
	}
}




void groupBox::updatePixmap( void )
{
#ifndef QT3
	const int c = 0;
	QColor bg_color = QApplication::palette().color( QPalette::Active,
							QPalette::Background );
#else
	const int c = 1;
	QColor bg_color = QApplication::palette().active().background();
#endif
	QPixmap pm( size() );
	pm.fill( bg_color.dark( 132 ) );

	QPainter p( &pm );

	// outer rect
	p.setPen( bg_color.dark( 200 ) );
	p.drawRect( 0, 0, width() - 1 + c, height() - 1 + c );

	// brighter line at bottom/right
	p.setPen( bg_color.light( 125 ) );
	p.drawLine( width() - 1, 0, width() - 1, height() - 1 );
	p.drawLine( 0, height() - 1, width() - 1, height() - 1 );

	// draw our led-pixmap
	p.drawPixmap( 2, 2, *s_ledBg );

	// draw groupbox-titlebar
	p.fillRect( 2, 2, width() - 4, 9, bg_color.dark( 300 ) );

	// draw line below titlebar
	p.setPen( bg_color.dark( 400 ) );
	p.drawLine( 2 + s_ledBg->width(), 11, width() - 3, 11 );

	// black inner rect
	p.drawRect( 1, 1, width() - 3 + c, height() - 3 + c );


	//p.setPen( QColor( 255, 255, 255 ) );
#ifndef QT3
	p.setPen( palette().color( QPalette::Active, QPalette::ButtonText ) );
#else
	p.setPen( colorGroup().buttonText() );
#endif
	p.setFont( pointSize<7>( font() ) );
	p.drawText( 22, 10, m_caption );

#ifdef QT4
	QPalette pal = palette();
	pal.setBrush( backgroundRole(), QBrush( pm ) );
	setPalette( pal );
#else
	setPaletteBackgroundColor( bg_color.dark( 132 ) );
	setErasePixmap( pm );
#endif
}




void groupBox::saveSettings( QDomDocument & _doc, QDomElement & _this,
							const QString & _name )
{
	m_led->saveSettings( _doc, _this, _name );
}




void groupBox::loadSettings( const QDomElement & _this, const QString & _name )
{
	m_led->loadSettings( _this, _name );
}




#include "group_box.moc"


#endif
