#!/usr/bin/perl

#
# editconfig.pl: Holds routines used by some scripts
# to manipulate config files.
#

# Return 0 if the file wasn't changed and 1 if the file was updated
sub AppendIfMissingLine {
    my ($filename, $line) = @_;
    my $updated = 0;

    my @lines;
    if (open(FILE, "<$filename")) {
        @lines = <FILE>;
        close(FILE);
    }

    $line .= "\n";

    if ( ! grep /^$line$/, @lines ) {
        $updated = 1;
        push(@lines, $line);
    }

    if ($updated) {
        print "Updating $filename\n" if $debug;
        open(FILE, ">$filename.new") || die "Unable to write $filename.new";
        print FILE @lines;
        close(FILE);
        rename "$filename.new", $filename;
    }
    return $updated;
}

# Return 0 if nothing changed, and 1 if the file was updated
sub UpdateOrAppendVariable {
    my ($filename, $variable, $content) = @_;
    my $updated = 0;
    my $newline = "$variable=$content\n";

    my @lines;
    if (open(FILE, "<$filename")) {
        @lines = <FILE>;
        close(FILE);
    }

    if (grep /^$variable=/, @lines ) {
        @lines = map { if ($_ =~ m/^$variable=/ && $_ ne $newline)
                       { $updated = 1;
                         $newline; }
                       else
                       { $_; }
                   } @lines;
    } else {
        $updated = 1;
        push(@lines, $newline);
    }
    if ($updated) {
        print "Updating $filename\n" if $debug;
        open(FILE, ">$filename.new") || die "Unable to write $filename.new";
        print FILE @lines;
        close(FILE);
        rename "$filename.new", $filename;
    }
    return $updated;
}

1;