"""
unit tests for module fileutils
squeleton generated by /home/syt/cvs_work/logilab/pyreverse/py2tests.py on Sep 08 at 09:1:31


Some file / file path manipulation utilities

"""
__revision__ = "$Id: unittest_textutils.py,v 1.6 2004/11/10 11:59:39 syt Exp $"

import unittest
import sys
import re
from os.path import join
from os import getcwd, linesep

from logilab.common.textutils import *


if linesep != '\n':
    import re
    LINE_RGX = re.compile(linesep)
    def ulines(string):
        return LINE_RGX.sub('\n', string)
else:
    def ulines(string):
        return string

class NormalizeTextFunctionTest(unittest.TestCase):

    def test_known_values(self):
        self.assertEqual(ulines(normalize_text('''some really malformated
        text.
With some times some veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy loooooooooooooooooooooong linnnnnnnnnnnes

and empty lines!
        ''')),
                         '''some really malformated text. With some times some
veeeeeeeeeeeeeeerrrrryyyyyyyyyyyyyyyyyyy loooooooooooooooooooooong
linnnnnnnnnnnes

and empty lines!''')

class NormalizeParagraphTC(unittest.TestCase):

    def test_known_values(self):
        self.assertEqual(ulines(normalize_text("""This package contains test files shared by the logilab-common package. It isn't
necessary to install this package unless you want to execute or look at
the tests.""", indent=' ', line_len=70)),
                         """\
 This package contains test files shared by the logilab-common
 package. It isn't necessary to install this package unless you want
 to execute or look at the tests.""")

        
class GetCsvFunctionTest(unittest.TestCase):

    def test_known(self):
        self.assertEqual(get_csv('a, b,c '), ['a', 'b', 'c'])

    
RGX = re.compile('abcd')
class PrettyMatchFunctionTest(unittest.TestCase):

    def test_known(self):
        string = 'hiuherabcdef'
        self.assertEqual(ulines(pretty_match(RGX.search(string), string)),
                         'hiuherabcdef\n      ^^^^')
    def test_known_values_1(self):
        rgx = re.compile('(to*)')
        string = 'toto'
        match = rgx.search(string)
        self.assertEqual(ulines(pretty_match(match, string)), '''toto
^^''')
        
    def test_known_values_2(self):
        rgx = re.compile('(to*)')
        string = ''' ... ... to to
 ... ... '''
        match = rgx.search(string)
        self.assertEqual(ulines(pretty_match(match, string)), ''' ... ... to to
         ^^
 ... ...''')
        
        


class SearchAllFunctionTest(unittest.TestCase):

    def test_known(self):
        string = 'hiuherabcdefabcd'
        self.assertEqual(len(searchall(RGX, string)), 2)

def suite():
    """return the unitest suite"""
    loader = unittest.TestLoader()
    testsuite = loader.loadTestsFromModule(sys.modules[__name__])
    return testsuite

def Run(runner=None):
    """run tests"""
    testsuite = suite()
    if runner is None:
        runner = unittest.TextTestRunner()
        # uncomment next line to write tests results in a file
        #runner.__init__(open('tests.log','w+'))    
    return runner.run(testsuite)
        
if __name__ == '__main__':
    Run()
