#!/bin/bash

set -e

PKG=`dpkg-parsechangelog | awk '/^Source/ { print $2 }'`
VERSION=`uscan --rename --verbose --force-download | 
    grep "Newest version on remote site is .* local version is .*" | 
    head -n 1 | 
    sed "s/Newest version on remote site is \([a-z0-9.]\+\),.*/\1/"`

#VERSION=`dpkg-parsechangelog | awk '/^Version/ { print $2 }'| cut -d"-" -f1`
#svn export  svn://scm.gforge.inria.fr/svn/logolexec/trunk/LogolExec ${PKG}-${VERSION}.orig

mkdir -p ../tarballs
cd ../tarballs

UTAR="${PKG}_${VERSION}.orig.tar.xz"
mv ../${UTAR} .
tar xfJ ${UTAR}

mv ${PKG}-${VERSION} ${PKG}-${VERSION}.orig

rm -rf ${PKG}-${VERSION}.orig/Doc/uml
rm -f ${PKG}-${VERSION}.orig/Doc/Service*
#mv ${PKG}-${VERSION}.orig/lib/antlrworks-1.4.2.jar .
rm -rf ${PKG}-${VERSION}.orig/lib/*
#mv antlrworks-1.4.2.jar ${PKG}-${VERSION}.orig/lib/
rm -rf ${PKG}-${VERSION}.orig/Doc/JavaDoc
chmod 755 ${PKG}-${VERSION}.orig/Doc/grammar/*.sh
chmod 755 ${PKG}-${VERSION}.orig/tools/*.sh
rm -f ${PKG}-${VERSION}.orig/Doc/*.mdr*
rm -f ${PKG}-${VERSION}.orig/prolog/*.exe
# Will be regenerated at build time
rm -f ${PKG}-${VERSION}.orig/src/org/irisa/genouest/logol/parser/*
# Will be rewritten from template
rm -f ${PKG}-${VERSION}.orig/tools/suffixSearch.sh


BZIP2="--best" tar -cjf ${PKG}_${VERSION}.orig.tar.bz2 ${PKG}-${VERSION}.orig

rm -rf ${PKG}-${VERSION}.orig
