package LogTrend::Agent::SNMPAgent::Traps;

use strict;
use vars qw(@ISA);

use Net::SNMP qw(:ALL);
@ISA = qw(Net::SNMP);

use Socket;
use Symbol qw(gensym);

sub new {
    my($class) = shift;
    my($this) = $class->SUPER::new(@_);

    my($proto) = getprotobyname('udp');
    $this->{_sockaddr} = sockaddr_in($this->{_port}, INADDR_ANY);

    $this->{_socket} = gensym();

        socket($this->{_socket}, PF_INET, SOCK_DGRAM, $proto)
    or  die "socket: $!";
        
	    bind($this->{_socket}, $this->{_sockaddr})
    or	die "bind(): $!";

    $this
}

sub GetTraps {
    my($this) = shift;
    my($rin) = '';
    my($sockaddr_in, $srcaddr);
    
    vec($rin, fileno($this->{'_socket'}), 1) = 1;

        select($rin, undef, undef, $this->{'_timeout'}) == 1
    or  return undef;

    $this->_object_clear_var_bind_list;
    $this->_object_clear_error;

        defined($sockaddr_in = $this->_udp_recv_buffer)
    or  die "Error while receiving buffer";

    ( undef, $srcaddr ) = sockaddr_in($sockaddr_in);

    [ $srcaddr, $this->_snmp_decode(TRAP) ]

}

sub DESTROY {
    my($self) = shift;

        defined($self->{_socket})
    and do {
        shutdown($self->{_socket},2);
        close($self->{_socket});
    };
}

1;
