#ifndef _UTILS_H_
#define _UTILS_H_

#include <time.h>

#ifndef WORD_BIT
#define WORD_BIT (sizeof(int)<<3)
#endif

#ifndef LONG_BIT
#define LONG_BIT (sizeof(long)<<3)
#endif

#define   READ	   0
#define   WRITE	1

typedef struct {
	time_t start_time;
	double extra_time,extra_stime,extra_utime;
} loki_time;

extern const char *FMsg,*IntErr,*MMsg,*AbMsg;
extern char *file_prefix;
extern char *file_dir;
extern int from_abt;

extern void abt(const char *, const int, const char *, ...);
extern char *copy_string(const char *);
extern char *make_file_name( const char *);
extern void print_start_time(const char *,const char *,char *,loki_time *);
extern void print_end_time(void);
extern int mystrcmp(const char *, const char *);
extern void qstrip(char *);
extern char **tokenize(char *,const int);
extern void gen_perm(int *,int);
extern void gnu_qsort(void *const,size_t,size_t,int(*)(const void *,const void *));
extern int txt_print_double(double,FILE *);
extern int txt_get_double(char *,char **,double *);

#define ABT_FUNC(msg) abt(__FILE__,__LINE__,"%s(): %s",FUNC_NAME,msg)

#endif
