#
# "@(#) $Id: CDR.py,v 1.2 2004/11/23 01:30:12 will Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import re
from backtick import backtick

_burnerDevices = None

def getBurnerDevices(rescan = False):
	global _burnerDevices
	if _burnerDevices==None or rescan:
		_burnerDevices = []
		devicePattern = re.compile('^\s*?(\d+),(\d+),(\d+)\s*?\d+\)\s+?\'(.+?)\'\s+?\'(.+?)\'')
		capPattern = re.compile('^\s+?Does write (.+?) media')
		speedPattern = re.compile('^\s+?Maximum write speed:.+?\(CD\s+?(\d+)x')
		try:
			deviceLines = backtick('cdrecord -scanbus | grep -v "*" | grep ","')
			for deviceLine in deviceLines.split('\n'):
				md = devicePattern.match(deviceLine)
				if md:
					dev = md.group(1)+','+md.group(2)+','+md.group(3)
					devName = md.group(4).strip()
					model = md.group(5).strip()
					capLines = backtick('cdrecord -prcap dev=%s' % dev)
					supports = []
					speed = 1
					for capLine in capLines.split('\n'):
						mc = capPattern.match(capLine)
						if mc:
							supports.append(mc.group(1))
						ms = speedPattern.match(capLine)
						if ms:
							speed = int(ms.group(1))
					if len(supports)>0:
						_burnerDevices.append({'Address':dev,'Manufacturer':devName,'Model':model,'Supports':supports,"MaxSpeed":speed})
		except: pass
	return _burnerDevices
	
def checkMedia2():
	import fcntl, os
	try:
		isValidCD = False
		fd = os.open('/dev/cdrom',os.O_RDONLY | os.O_NONBLOCK)
		s = fcntl.ioctl(fd,0x5326) # check if tray closed, media present
		if s==4:
			s = fcntl.ioctl(fd,0x5327) # check media type
			isValidCD = (s==0) # valid if audio or mixed
		os.close(fd)
		return isValidCD
	except:
		try: os.close(fd)
		except: pass
		return False

def checkMedia(device):
	# call 'cdrdao disk-info --device --driver'
	from utils import *
	c = LWaitCursor()

	checkLines = ""
	try:
		checkLines = backtick("cdrdao disk-info --device %s --driver generic-mmc"%(device['Address']))
	except:
		pass
	pattern = re.compile(r"CD-R empty.*(yes|no)", re.MULTILINE)
	r = pattern.search(checkLines)
	print checkLines
	if r and r.group(1) == "yes":
		return True
	else:
		print "ejecting"
		try:
			backtick("eject")
		except:
			pass
		return False
	
def canBurn():
	return len(getBurnerDevices())>0

if __name__=='__main__':
	ds = getBurnerDevices()
	print ds
	for d in ds:
		print checkMedia(d)
		
