from qt import *
from utils import *

import os

class LConfig(QSettings):
	def __init__(self, appname):
		QSettings.__init__(self)
		self.appname = appname
		path = str(os.path.expanduser("~/.kde/share/config"))
		self.insertSearchPath(QSettings.Unix, path)

	def writeEntry(self, section, name, string):
		QSettings.writeEntry(self, "/%s/%s/%s"%(self.appname, section, name), string)

	def readEntry(self, section, name, default=False):
		s, b = QSettings.readEntry(self, "/%s/%s/%s"%(self.appname, section, name))
		if b:
			return str(s)
		return default
		
	def writeEntryInt(self, section, name, int):
		QSettings.writeEntry(self, "/%s/%s/%s"%(self.appname, section, name), LUtils.safeToInt(int))
		
	def readEntryInt(self, section, name, default=0):
		s, b = QSettings.readEntry(self, "/%s/%s/%s"%(self.appname, section, name))
		if b:
			return LUtils.safeToInt(s)
		return default

	def writeEntryRect(self, section, name, r):
		l = [r.left(), r.top(), r.width(), r.height()]
		QSettings.writeEntry(self, "/%s/%s/%s"%(self.appname, section, name), str(l))
		
	def readEntryRect(self, section, name, default):
		s, b = QSettings.readEntry(self, "/%s/%s/%s"%(self.appname, section, name))
		if b and s:
			l = eval(str(s))
			if len(l) == 4:
				return QRect(l[0], l[1], l[2], l[3])
		return default
		
	def writeEntryList(self, section, name, list):
		QSettings.writeEntry(self, "/%s/%s/%s"%(self.appname, section, name), str(list))
		
	def readEntryList(self, section, name, default=[]):
		s, b = QSettings.readEntry(self, "/%s/%s/%s"%(self.appname, section, name))
		if b:
			return eval(str(s))
		return default
		
	def writeEntryBool(self, section, name, bool):
		if bool:
			s = "True"
		else:
			s = "False"
		QSettings.writeEntry(self, "/%s/%s/%s"%(self.appname, section, name), s)

	def readEntryBool(self, section, name, default=False):
		print section, name
		s, b = QSettings.readEntry(self, "/%s/%s/%s"%(self.appname, section, name))
		if b:
			return s == "True"
		return default
	
	def serializeCombo(self, widget, category, key, bRestore, default=None):
		if bRestore:
			s = self.readEntry(category, key, default)
			if s:
				i = widget.listBox().index(widget.listBox().findItem(s))
				if i < 0 and s != default:
					i = widget.listBox().index(widget.listBox().findItem(default))
					if i < 0: i = 0
				widget.setCurrentItem(i)
		else:
			self.writeEntry(category, key, str(widget.currentText()))
##~ 		print "COMBO %s %s='%s'"%(bRestore and "RESTORE" or "SAVE   ", key, str(widget.currentText()))
			
	def serializeEdit(self, widget, category, key, bRestore, default=None):
		if bRestore:
			widget.setText(self.readEntry(category, key, default))
		else:
			self.writeEntry(category, key, str(widget.text()))
##~ 		print "EDIT  %s %s='%s'"%(bRestore and "RESTORE" or "SAVE   ", key, str(widget.text()))
	
	def serializeRadioGroup(self, widgets, category, key, bRestore, default=0):
		if bRestore:
			widgets[int(self.readEntryInt(category, key, default))].setChecked(True)
		else:
			for i, widget in enumerate(widgets):
				if widget.isChecked():
					self.writeEntryInt(category, key, i)
					break
##		for i, widget in enumerate(widgets):
##			print "RADIO %d %s %s"%(i,widget.isChecked() and "[X]" or "[ ]", widget.text())
			
			
			
