#import _pygphoto
from qt import *
import cStringIO
import os, errno
import re
import backtick
from utils import *
from kdeemul import *


class LDirImport:
	def __init__(self, files):
		self.filelist = files
		self.__validExtensions = ["."+x for x in LSettings.validFileTypes()]
		self.deletePrompt = None
##		self.deletePrompt = i18n("Do you want to delete all the images from the original location?")

	def __isValidFile(self, filePath):
		filePath = str(filePath)
		(path, filename) = os.path.split(str(filePath))
		if (str(filename)=="." or str(filename)==".."):
			return False
		elif os.path.isdir(str(filePath)):
			return True
		else:
			extension = os.path.splitext(str(filePath))[1]
			extension = extension.lower()
			return extension in self.__validExtensions
		return False	
			
	def expandFileList(self, files):
		def visit(args, dirname, files):
			if dirname.startswith(LSettings.libraryPath):
				return
			f = [ str(os.path.join(dirname, f)) for f in files ]
			f = [ x for x in f if self.__isValidFile(x) and not os.path.isdir(x) ]
			args += f
		def expandDir(path):
			l = []
			os.path.walk(path, visit, l)
			return l
		expand = lambda x: not os.path.isdir(x) and [x] or expandDir(x)
		files =  [ f for l in files for f in expand(l) if self.__isValidFile(l) ]
		return files
	
	def getFilename(self, item):
		return os.path.split(item)[1]

	def getFileList(self):
		files = [str(f) for f in self.filelist]
		self.files = self.expandFileList(files)
		return self.files

	def getInsertAlbumPath(self, file):
		return None
		
	def copyToFilesystem(self, file):
		# do nothing, just return path to file
		return file
		
	def cleanupFilesystem(self, file):
		pass
		
	def copyToLibrary(self, srcPath, dstPath):
##~ 		print "LDirImport copyToLibrary",srcPath, dstPath
		shutil.copy2(srcPath, dstPath)
		os.chmod(dstPath, 0666)
##~ 		print "LDirImport end"
	
	def deleteImage(self, fileItem):
		os.remove(fileItem)

	def getDisplayName(self):
		return str(self.filelist[0])
		
	def cleanupImport(self):
		if len(self.files) == 0:
			return
		if self.deletePrompt == None:
			return
		result = QMessageBox.warning(None, i18n("Lphoto: Import Complete"), self.deletePrompt, i18n("Yes, delete the images."), i18n("No"),  None,  1, 1)
		if result == 0:
			progress = QProgressDialog("LPhoto",None,len(self.files),None,"progress",True)
			progress.setMinimumDuration(0)
			progress.setCaption(i18n("Deleting files"))
			progress.setTotalSteps(len(self.files))
			progress.setProgress(0)
			i = 0
			for file in self.files:
				progress.setLabelText(i18n("Deleting %s"%(file)))
				try:
					self.deleteImage(file)
				except:
					pass
				i = i + 1
				progress.setProgress(i)
				if progress.wasCancelled():
					return
					
class LAlbumImport(LDirImport):
	def __init__(self, files):
		LDirImport.__init__(self, files)
		self.path = files[0]
	def __getListFromPath(self, path):
		list = path.split(os.sep)
		#remove empties from head and tail
		if not len(list[0]):
			del list[0]
		if not len(list[len(list)-1]):
			del list[len(list)-1]
		return list

	def getInsertAlbumPath(self, file):
		# [a,b,c] & [a,b,c,d,e.jpg] -> [c,d,e.jpg]
		base = self.__getListFromPath(str(self.path))
		dst = self.__getListFromPath(str(file))
		if not LUtils.isListChild(base, dst):
				return None 
		del dst[len(dst)-1] # remove filename
		dst = dst[len(base)-1:len(dst)]
		return dst

class LDragImport(LDirImport):
	def __init__(self, files, albumPath):
		LDirImport.__init__(self, files[0])
		self.albumPath = albumPath
		self.files = []
		for file in files:
			self.files.append(str(file))
	
	def getInsertAlbumPath(self, file):
		return self.albumPath
		
	def getFileList(self):
		return self.expandFileList(self.files)
		
	def getDisplayName(self):
		return i18n("Drag Import")

class LMassStorageCamera(LDirImport):
	def __init__(self, path):
		LDirImport.__init__(self, [path])
		self.rootPath = path
		self.path = os.path.join(path, "dcim")
		self.deletePrompt = i18n("Do you want to delete all the images from %s?" % (self.getDisplayName()))
	
	def class_findCameras():
		print "find usb cameras"
		cameras = []
		mntPaths = [str(os.path.expanduser('~')), "/mnt"]
		for mntPath in mntPaths:
			if os.access(mntPath, os.R_OK) and os.path.isdir(mntPath):
				try:
					dirs = os.listdir(mntPath)
					for dir in dirs:
						# look for misc/autprint.mrk
						searchpath = os.path.join(mntPath, dir, "misc", "autprint.mrk")
						if LUtils.fileExists(searchpath):
							cameras.append(LMassStorageCamera(str(os.path.join(mntPath, dir))))
						else:
							searchpath = os.path.join(mntPath, dir, "dcim")
							if os.path.exists(searchpath):
								cameras.append(LMassStorageCamera(str(os.path.join(mntPath, dir))))
				except:
					pass
		return cameras
		
	findCameras = staticmethod(class_findCameras)
		
	def getDisplayName(self):
		if hasattr(self, "name"):
			return self.name
		name = "unknown camera"
		# try to read camera from /proc/scsi/scsi
		try:
			mc = None
			devPattern = re.compile(r"%s.*,dev=(.*?),"%(self.rootPath), re.MULTILINE)
			longPattern = re.compile(r"/dev/scsi/host(\d*)/bus(\d*)/target(\d*)/(.*?) on %s"%(self.rootPath), re.MULTILINE)
			mountLines = backtick.backtick("mount")
			dc = devPattern.search(mountLines)
			if dc:
				devPath = dc.group(1)
				scsiPath = os.readlink(str(devPath))
				statPattern = re.compile(r"scsi/host(\d*)/bus(\d*)/target(\d*)/lun(\d*)/part(\d*)")
				mc = statPattern.match(scsiPath)
			else:
				mc = longPattern.search(mountLines)
			if mc:
				#scsi1 Channel: 00 Id: 00 Lun: 00
				scsiPattern = re.compile(r"scsi%d Channel:\s*%02d Id:\s*%02d.*\s*Vendor:\s*(.*?)\s*Model:\s*(.*?)\s*Rev:\s*" % (int(mc.group(1)), int(mc.group(2)), int(mc.group(3))), re.MULTILINE)
				# Vendor: Casio    Model: QV DigitalCamera Rev: 1000
				scsiLines = open("/proc/scsi/scsi").read()
				mc = scsiPattern.search(scsiLines, re.MULTILINE)
				if mc:
					name = mc.group(1)+" "+mc.group(2)
					self.name = name
					return name
		except:
			pass
		
		# try to read camera name from autprint.mrk
		filename = os.path.join(self.rootPath, "misc", "autprint.mrk")
		regex = re.compile("GEN CRT\s*=\s*\"(.*)\"")
		try:
			for line in open(filename, "r").readlines():
				if regex.search(line): 
					before, name, after = regex.split(line)
					self.name = name
		except:
			pass
		return name
		
class GPhotoCamera:
	def class_findCameras():
		cameras = []
		cameraPattern = re.compile(r"(.*?)\s*usb\:")
		print "gphoto find"
##		try:
		cameraLines = backtick.backtick("gphoto2 --auto-detect")
		print cameraLines
		bFlag = False
		for line in cameraLines.split("\n"):
			print line
			mc = cameraPattern.match(line)
			if mc:
				cameras.append(GPhotoCamera(mc.group(1)))
				print "*",mc.group(1),"*"
##		except RuntimeError:
			pass
		return cameras
	findCameras = staticmethod(class_findCameras)
	
	def __init__(self, name):
		self.name = name
	
	def getDisplayName(self):
		return self.name
		
	def getFilename(self, item):
		return item['name']

	def getInsertAlbumPath(self, fileItem):
		return None
		
	def getFileList(self):
		print "get files", self.name
		print "gphoto2 --camera \"%s\" -L" % (self.name)
		files = []
		fileLines = backtick.backtick("gphoto2 --camera \"%s\" -L" % (self.name))
		filePattern = re.compile(r"^#(\d+)\s+(.*?)\s.*image/(.+)$")
		for line in fileLines.split("\n"):
			mf = filePattern.match(line)
			if mf:
				files.append({'index':mf.group(1), 'name':mf.group(2), 'type':mf.group(3)})
				print mf.group(1), mf.group(2), mf.group(3)
		self.files = files
		return files

	def copyToFilesystem(self, fileItem):
		filename = self.getFilename(fileItem)
		tmpEnv = os.environ.get('TMP','/tmp')
		tmpPath = str(os.path.join(tmpEnv, filename))
		os.system("gphoto2 -q --camera \"%s\" -p %s --filename \"%s\"" 
			% (self.name, fileItem['index'], tmpPath))
		return tmpPath
		
	def cleanupFilesystem(self, tmpPath):
		LUtils.removeFile(tmpPath)
		
	def copyToLibrary(self, srcPath, dstPath):
		print "copyToLibrary",srcPath, dstPath
		shutil.move(srcPath, dstPath)
		
	def deleteImage(self, fileItem):
		os.system("gphoto2 --camera \"%s\" -d %s" % (self.name, fileItem['index']))

	def cleanupImport(self):
		if len(self.files) == 0:
			return
		result = QMessageBox.warning(None, i18n("Lphoto: Import Complete"), i18n("Do you want to delete all the images from %s?"%(self.getDisplayName())), i18n("Yes, delete the images."), i18n("No"),  None,  1, 1)
		if result == 0:
			progress = QProgressDialog("LPhoto",None,len(self.files),None,"progress",True)
			progress.setMinimumDuration(0)
			progress.setCaption(i18n("Deleting files"))
			progress.setTotalSteps(len(self.files))
			progress.setProgress(0)
			i = 0
			rlist = list(self.files)
			rlist.reverse()
			for file in rlist:
				progress.setLabelText(i18n("Deleting %s"%(file['name'])))
				try:
					self.deleteImage(file)
				except:
					pass
				i = i + 1
				progress.setProgress(i)
				if progress.wasCancelled():
					return
	
class LImportSession:
	def __init__(self):
		pass
		
	def findFirstCamera(self):
		wc = LWaitCursor()
		print "scanning for cameras"
		# get usb camera first, gphoto detects some cameras that are already mounted as usb drives
		# get list of attached cameras
		cameras = []
		cameras = LMassStorageCamera.findCameras()
##~ 		cameras = GPhotoCamera.findCameras()
		if len(cameras):
			return cameras[0]
		else:
			cameras = GPhotoCamera.findCameras()
##~ 			cameras = LMassStorageCamera.findCameras()
		if cameras and len(cameras):
			return cameras[0]	
		else:
			return None
		
