from qt import *
##~ from photolibrary import LPhotoLibrary
from utils import *

import os, errno
import shutil


class LImportItemEvent(QCustomEvent):
	id = QEvent.User+1
	def __init__(self, key, dict, progress, total, albumPath=None):
		QCustomEvent.__init__(self, self.id)
		self.setData(dict)
		self.key = key
		self.dict = dict
		self.progress = progress
		self.total = total
		self.albumPath = albumPath
		
	def getKey(self): return self.key		
	def getDict(self): return self.dict		
	def getAlbumPath(self): return self.albumPath
	def getProgress(self): return self.progress
	def getTotal(self): return self.total
		
		
class LImportStatusEvent(QCustomEvent):
	id = QEvent.User+2
	def __init__(self, progress, total):
		QCustomEvent.__init__(self, self.id)
		self.progress = progress
		self.total = total
		
	def getProgress(self): return self.progress		
	def getTotal(self): return self.total


class LImportCompleteEvent(QCustomEvent):
	id = QEvent.User+3
	def __init__(self, source):
		QCustomEvent.__init__(self, self.id)
		self.source = source
		
	def getSource(self): return self.source
		
		
class LImportThread(QThread):
	def __init__(self, target):
		QThread.__init__(self)
		self.target = target
		
	def setImportObject(self, source):
		self.source = source
		
	def __filenameGenerator(self, path, filename):
		yield filename
		(a,b) = os.path.splitext(filename)
		i = 1
		while True:
			yield a + str(i) + b
			i=i+1
	
	def __checkDuplicates(self, n, e, b): # n = new file, e = existing file, b = original backup(b may not exist)
		# check to see if this new file is a duplicate of an existing file or
		# the original file.  if sizes match, do an md5 on the file
		# the md5 only looks at the first 10K or so
		size = os.path.getsize(n)
		
		if size == os.path.getsize(e):
			if LUtils.md5(n) == LUtils.md5(e):
				return True			
		if LUtils.fileExists(b): 
			if size == os.path.getsize(b):
				if LUtils.md5(n) == LUtils.md5(b):
					return True			
		return False
		
	def __buildPhotoDictionary(self, source, file):
		photo = {}
		
				
	def run(self):
		from photolibrary import LPhotoLibrary
		from utils import LUtils
		import time
		
		files = self.source.getFileList()
		i = 0
		total = len(files)
		# send zero event to init progress bar
		QApplication.postEvent(self.target, LImportStatusEvent(i, total))
		for file in files:
			i = i + 1
			tmpPath = self.source.copyToFilesystem(file) # temporary location in our filesystem
			filename = self.source.getFilename(file) # filename of photo
			albumPath = self.source.getInsertAlbumPath(file) # returns album path if exists (usually None)			
			mtime = os.path.getmtime(str(tmpPath))
			importDestPath = str(os.path.join(LPhotoLibrary.libraryPath(), LUtils.datePath(mtime)))
			thumbPath = os.path.join(importDestPath, "Thumbs")
			LUtils.ensureDirectory(importDestPath)
			LUtils.ensureDirectory(thumbPath)

			proposedPath = str(os.path.join(importDestPath, filename))
			backupPath = str(os.path.join(importDestPath,"originals",filename))
			key = filename
			
			#copy file into library
			for filename in self.__filenameGenerator(importDestPath, filename):
				proposedPath = str(os.path.join(importDestPath, filename))
				key = filename
				if not LUtils.fileExists(proposedPath):
					break
					
				if self.__checkDuplicates(tmpPath, proposedPath, backupPath):
					key = None
					break
			
			# if key is set then this is a new file, move into library								
			if key:  
				self.source.copyToLibrary(tmpPath, proposedPath)
			self.source.cleanupFilesystem(tmpPath)

			#create thumbnail
			thumbFilename = str(os.path.join(thumbPath, filename))
			(w,h) = LUtils.downsizeImage(proposedPath, thumbFilename)
			if h==0 or w==0:
				continue # no width or height, this image is corrupt
			
			# create the dictionary for this image
			photo = {}
			photo['Date'] = mtime
			photo['ImportDate'] = int(time.time())
			photo['Caption'] = filename
			photo['Rating'] = 0
			photo['Comments'] = ""			
			photo['ImagePath'] = proposedPath
			photo['ThumbPath'] = thumbFilename
			photo['AspectRatio'] = w/float(h)
			photo['Width'] = w
			photo['Height'] = h
			photo['Format'] = QImage.imageFormat(proposedPath)
			
			QApplication.postEvent(self.target, LImportItemEvent(key, photo, i, total, albumPath))
			
		#photo dict is complete, send back to library
		print "importthread complete"
		QApplication.postEvent(self.target, LImportCompleteEvent(self.source))
