from PListParser import *
from qtxml import *
from kdefx import *
from kdeemul import *
from photo import *

from utils import *
from importsession import *
from importthread import *

import sys
import os, errno
import shutil
import copy
import time
import cPickle
import itertools

class LPhotoLibrary(QObject):
	strLatestRoll = "Latest Import"
	strMasterAlbum = "Photo Library"
	strTrash = "Trash"

	def libraryPath(self):
		return LSettings.libraryPath
	libraryPath = classmethod(libraryPath)

	def __init__(self, app):
		QObject.__init__(self)
		self.app = app
		self.rootPList = None
		self.firstTime = False
		self.readLibrary()
		if not(self.rootPList):
			self.newLibrary()
			self.firstTime = True

	def __del__(self):
		print "write library"
		self.writeLibrary()

	def readLibrary(self):
		# open XML file
		print "Reading Library"
		filename = os.path.join(self.libraryPath(), "AlbumData.bin")
		importDestPath = self.libraryPath()
		LUtils.ensureDirectory(importDestPath)
		if LUtils.fileExists(filename):
			try:
				inf = open(filename, mode="rb")
				self.rootPList = cPickle.load(inf)
				inf.close()
			except EOFError, IOError:
				self.PList = None
		if self.rootPList:
			return

		try:
			filename = os.path.join(self.libraryPath(), "AlbumData.xml")
			reader = PListReader()
			self.rootPList = reader.parse(filename)
		except IOError:
			return
			
	def fastWrite(self):
		filename = os.path.join(self.libraryPath(), "AlbumData.bin")
		ouf = open(filename, mode="wb")
		cPickle.dump(self.rootPList, ouf, 1)
		ouf.close()

	def writeLibrary(self):
		self.fastWrite()
		filename = os.path.join(self.libraryPath(), "AlbumData.xml")
		writer = PListWriter()
		writer.unparse(self.rootPList, filename)

	def newLibrary(self):
		print "Creating Default Empty Library"
		self.rootPList = [{'List of Albums':[],'Master Image List':{},'TrashExtraInfo':{},'Major Version':1,'Minor Version':0,'Application Version':'1.0','Archive Path':str(self.libraryPath())}]
		album = self.__newAlbumFromPath([self.strMasterAlbum])
		album['Master'] = True
		album['Type'] = "Master"
		album['W'] = False
		album['DisplayName'] = i18n("Photo Library")
		album = self.__newAlbumFromPath([self.strLatestRoll])
		album['Type']="Roll"
		album['W'] = False
		album['DisplayName'] = i18n("Latest Import")
		album = self.__newAlbumFromPath([self.strTrash])
		album['Type']=self.strTrash
		album['Trash'] = True
		album['W'] = False
		album['DisplayName'] = i18n("Trash")

		
	def getMasterAlbum(self):
		return self.getAlbum([self.strMasterAlbum])

 	def getMasterImageList(self):
 		return self.rootPList[0]['Master Image List']

	def getAlbumList(self):
		return self.rootPList[0]['List of Albums']

	def getTrashExtraInfo(self):
		return self.rootPList[0]['TrashExtraInfo']
		
	def __newAlbumFromPath(self, path):
		albums = self.rootPList[0]['List of Albums']
		i = 0
		found = True
		while found and i < len(path):
			found = False
			for album in albums:
				if album['AlbumName'] == path[i]:
					if i == len(path)-1:
						return album
					else:
						i = i + 1
						albums = album['AlbumList']
						found = True

		#album was not found, create in albums
		for j in xrange(i, len(path)):
			album = self.__newAlbum(path[j])
			albums.append(album)
			albums = album['AlbumList']
		return album

	def __newAlbum(self, name, keys=[]):
		album = {}
		album['AlbumName'] = name
		album['RepeatSlideShow'] = False
		album['SecondsPerSlide'] = 5
		album['KeyList'] = copy.copy(keys)
		album['AlbumList'] = []
		album['W']=True
		album['Sort']="Date"
		album['Type']="normal"
		album['Option']={}
		#create filesystem folder
		return album

	def slotNewAlbum(self, parent = []):
		album = self.__newAlbum(self.__getNewAlbumName(parent), [])
		if parent:
			dst = self.getAlbum(parent)['AlbumList']
		else: 
			dst = self.rootPList[0]['List of Albums']
		dst.append(album)
		self.emit(PYSIGNAL("newAlbum"),(parent + [album['AlbumName']], None))

	def slotNewAlbumWithKeys(self, keys, src, parent = []):
		album = self.__newAlbum(self.__getNewAlbumName(parent), [])
		if parent:
			dst = self.getAlbum(parent)['AlbumList']
		else: 
			dst = self.rootPList[0]['List of Albums']
		dst.append(album)
		for key in keys:
			self.__addPhotosEnsureMasterAlbum(key)
			self.__addPhotosToAlbumPath(key, [album['AlbumName']])
		self.emit(PYSIGNAL("newAlbum"),(parent + [album['AlbumName']], None))
		
	def __getNewKey(self, key):
		base = key
		i = 1
		while (self.rootPList[0]['Master Image List'].has_key(key)):
			key = base + str(i)
			i = i + 1
		return key

	def __getNewAlbumName(self, parent=[]):
		i = 1
		while True:
			name = i18n("Album ") + str(i)
			if not(self.getAlbum(parent + [name])):
				return name
			i = i + 1
		
	def getAlbum(self, path):
		albums = self.rootPList[0]['List of Albums']
		
		for i, name in enumerate(path):
			m = [ a for a in albums if a['AlbumName']==name]
			if m:
				if i == len(path)-1:
					return m[0]
				else:
					albums = m[0]['AlbumList']
			else:
				break
		return None		

	def getImage(self, key):
		return self.rootPList[0]['Master Image List'].get(key, None)
		
	def getPhoto(self, key):
		return Photo(key, self.rootPList[0]['Master Image List'].get(key, None))
		
##	def __refreshThumbnail(self, dict):
##		(w,h) = LUtils.downsizeImage(dict['ImagePath'], dict['ThumbPath'])
##		dict['Width'] = w
##		dict['Height'] = h
##		dict['AspectRatio'] = w/float(h)

	def slotAddPhotosToAlbum(self, path, keys, srcPath):
##~ 		print "addPhotosToAlbum",path,keys
		album = self.getAlbum(path)
		srcAlbum = self.getAlbum(srcPath)
		if album and srcAlbum:
			if srcAlbum['Type'] == self.strTrash:
				# move image out of trash
				for key in keys:
					self.__addPhotosEnsureMasterAlbum(key)
					self.__addPhotosToAlbumPath(key, path)
				self.emit(PYSIGNAL("updateAlbums"),([path,srcPath],None))
			else:
				albumKeys = album['KeyList']
				albumKeys += [k for k in keys if k not in albumKeys]
				self.emit(PYSIGNAL("updateAlbums"),([path],None))
				# if album is 'normal' create filesystem links here

	def trashAddImageWithAlbums(self, key, albums): # when an image is deleted, the locations it was removed from are saved
		self.getTrashExtraInfo()[key] = albums
		self.getAlbum([self.strTrash])['KeyList'].append(key)

	def trashKeyList(self, path, keys):
		# normal album -> trash, just remove those images from the album.  The images do not go into the trash unless they are deleted from the MasterList
		album = self.getAlbum(path)
		if album:
			if album['Type']=="Master" or album['Type']=="Roll": #move keys from master list to trash list
				self.trashKeyListFromMaster(keys)
			else: # remove keys from this album only
				result = QMessageBox.warning(None, 
					i18n("Lphoto: Remove Album"), 
					i18n("Do you want to remove %s from this album or from all albums?"
						%(len(keys)==1 and "this photo" or "these photos")),
					i18n("Remove from ALL albums"), 
					i18n("Just this album"),  i18n("Cancel"),  1, 1)
				if result == 0:
					self.trashKeyListFromMaster(keys)
				elif result == 1:
					self.trashKeyListFromAlbum(album, keys)
				else:
					return
				self.emit(PYSIGNAL("updateAlbums"),([path],None))
		#else:
		self.fastWrite()

	def trashKeyListFromAlbum(self, album, keys):
		albumKeys = album['KeyList']
		for key in keys:
			if key in albumKeys:
				albumKeys.remove(key)
				# remove filesystem links here
				
	def trashKeyListFromMaster(self, keys):
		# verify with user
		accum = []
		for key in keys: 		# add key to trash with album list
			albumPaths = self.__albumPathsFromKeys([key])
			self.trashAddImageWithAlbums(key,albumPaths)
			accum.extend([i for i in albumPaths if i not in accum])	 # union of albumPaths

		# delete keys from each album
		for path in accum:
			self.trashKeyListFromAlbum(self.getAlbum(path), keys)
			
		#more effcient way to do this... I'm sure
		self.emit(PYSIGNAL("updateAlbums"),(accum, None))
		
	def removeAlbum(self, path):
		albums = self.rootPList[0]['List of Albums']
		i = 0
		while i<len(path):
			name = path[i]
			for album in albums:
				if album['AlbumName'] == name:
					if i == len(path)-1:
						albums.remove(album)
						# remove filesystem folder
						return album
					else:
						albums = album['AlbumList']
						break
			i = i + 1

	def trashAlbum(self, path):
		album = self.removeAlbum(path)
		if album:
			self.emit(PYSIGNAL("delAlbum"),(path, None))

	def renameAlbum(self, path, newName):
		album = self.getAlbum(path)
		if album:
			album['AlbumName'] = str(newName)
##~ 			print "Album " + str(path) + " -> " + str(newName)
			# rename filesystem folder
			
	def __albumPathsFromKeysRecurse(self, keys, albums, list, path):
		for album in albums:
			albumKeys = album['KeyList']
			childPath = path + [album['AlbumName']]
			for key in albumKeys:
				if key in keys:
##~ 					print "adding album",childPath
					list.append(childPath)
					break
			self.__albumPathsFromKeysRecurse(keys,album['AlbumList'],list,childPath)

	def __albumPathsFromKeys(self, keys):#make recursive
		list = []
		albums = self.rootPList[0]['List of Albums']
		self.__albumPathsFromKeysRecurse(keys, albums, list, [])
		self.fastWrite()
		return list

	def trashRestoreImage(self, key):
##~ 		print "Restore from Trash" # add key back to any albums it came from
		albumNames = self.getTraskExtraInfo()[key]
		for albumName in albumNames:
			self.slotAddPhotosToAlbum(albumName, [key])
		self.trashKeyListFromAlbum(self.getAlbum([self.strTrash]), [key])
		
	def trashEmptyTrash(self):
		wc = LWaitCursor()
		keys = 	self.getAlbum([self.strTrash])['KeyList']
		mil = self.rootPList[0]['Master Image List']
		while len(keys):
			dict = self.getImage(keys[0])
			if dict:
				(dir, filename) = os.path.split(dict['ImagePath'])
				bdir = os.path.join(dir,"originals")
				bpath = os.path.join(bdir, filename)
				LUtils.removeFile(bpath)
				LUtils.removeFile(dict['ImagePath'])
				LUtils.removeFile(dict['ThumbPath'])
				#remove from master image list
				del mil[keys[0]]
			del keys[0]
		self.emit(PYSIGNAL("updateAlbums"),([[self.strTrash]], None))
			

##~ 	def trashDeleteImagePerm(self, key):
##~ 		print "Remove from trash"
##~ 		# verify with user
##~ 		# remove from trash
##~ 		
##~ 		# remove from Master Image List
##~ 		# delete file and thumbnail, if last file in directory, remove directory

	def setImageCaption(self, key, caption):
##~ 		print "Setting Image Caption",key,":",caption
		p = self.getImage(key)
		if p:
			p['Caption'] = str(caption)
			self.emit(PYSIGNAL("setCaption"),(key,None))

	def setImageDate(self, key, date):
		# this should update the auto date albums
		p = self.getImage(key)
		if p:
			p['Date'] = date
			
	def setImageRating(self, key, rating):
		p = self.getImage(key)
		if p and p['Rating'] != int(rating):
			p['Rating'] = int(rating)
			self.emit(PYSIGNAL("setRating"),(key,None))
			
	def setImageComment(self, key, comment):
		p = self.getImage(key)
		if p:
			p['Comments']=str(comment)
			
	def __printAlbumDebug(self, list=None, level=0):
		print ("photolibrary:: printAlbumDebug")
		if not list:
			list = self.rootPList[0]['List of Albums']
		for album in list:
			s = " " * level
			print s, album['AlbumName']
			albums = album['AlbumList']
			if albums:
				self.__printAlbumDebug(albums, level+1)
				
	def __findKeyFromFilename(self, filename):
		it = self.getMasterImageList().iteritems()
		for k,v in it:
			if v['ImagePath']==filename:
				return k
		return None
		
	def __addPhotoToMasterAlbum(self, key, dict):
		# add to master image list
		key = self.__getNewKey(key)
		self.getMasterImageList()[key] = dict
		
		# add to master album, roll album
		masterAlbum = self.getAlbum([self.strMasterAlbum])
		masterAlbum['KeyList'].append(key)
		roll = self.getAlbum([self.strLatestRoll])
		roll['KeyList'].append(key)

		return [self.strMasterAlbum,self.strLatestRoll], key
		
	def __addPhotosEnsureMasterAlbum(self, key):
		# photo is already in master image list, make sure it is not in trash
		albums = []
		masterAlbum = self.getAlbum([self.strMasterAlbum])
		masterList = masterAlbum['KeyList']
		if not key in masterList: 
			masterList.append(key)
			albums.append(masterAlbum['AlbumName'])
		
		# if key is in trash, move to master album
		trashList = self.getAlbum([self.strTrash])['KeyList']
		if key in trashList: 
			trashList.remove(key)
			self.emit(PYSIGNAL("updateAlbums"),([[self.strTrash]],None)) # update trash separately

		return albums

	def __addPhotosToAlbumPath(self, key, albumPath):
		albums = []
##~ 		print "addPhotoToAlbum=",albumPath
		if albumPath:
			album = self.getAlbum(albumPath)
			if not album:
				album = self.__newAlbumFromPath(albumPath)
				self.emit(PYSIGNAL("addAlbum"),(albumPath, None))
			if album == self.getAlbum([self.strMasterAlbum]):
				return albums
			keys = album['KeyList']
			# put this key at the end of the list
			if key not in keys: 
				keys.append(key)
				albums.append(album['AlbumName'])
		return albums
		
	def __addPhotoToAlbumsEvent(self, key, dict, albumPath):
		# if key == None then the import thread found that the file already exists
		albums = []
		if key: # this is a new file
			albums, key = self.__addPhotoToMasterAlbum(key, dict)
		else: # the file already exists, try to find the key from the filename
			filename = dict['ImagePath']
			key = self.__findKeyFromFilename(filename)
			if not key:
				# the file exists, but is not in the library
				# this happens in testing a fair amount, but should not happen in production
				# unless we crashed during an import or delete or database was manually deleted
##~ 				print "File exists, but is not in master list", filename
				albums, key = self.__addPhotoToMasterAlbum(os.path.split(filename)[1], dict)
			else: # the key is in the master image list, make sure 
				albums = self.__addPhotosEnsureMasterAlbum(key)

		albums.extend(self.__addPhotosToAlbumPath(key, albumPath))		
		return albums, key
			
		
	def event(self, e):
		if e.type() == LImportItemEvent.id:
			albums, key = self.__addPhotoToAlbumsEvent(e.getKey(), e.getDict(), e.getAlbumPath())
			self.emit(PYSIGNAL("importPhoto"),(albums, key, e.getProgress(), e.getTotal()))	
			self.fastWrite()
			return True
		elif e.type() == LImportStatusEvent.id:
			self.emit(PYSIGNAL("importPhoto"),([], None, e.getProgress(), e.getTotal()))
			return True
		elif e.type() == LImportCompleteEvent.id:
##~ 			print "import completed"
			source = e.getSource()
			self.emit(PYSIGNAL("importComplete"),(source, None))
			return True
			
		else:
			print "Non User Event Received",e.type()
			return False
			
	def __rotateRoll(self):
		# take the current 'Latest Import' and move its contents to a child album of Roll
		latestRoll = self.getAlbum([self.strLatestRoll])
		if len(latestRoll['KeyList']) == 0:
			return 
			
		if not latestRoll.has_key('RollCount'):
			i = 1
		else:
			i = latestRoll['RollCount'] + 1
		latestRoll['RollCount'] = i
		
		title = i18n("Roll %d"%(i))
		if latestRoll.has_key('ImportDate'):
			title = i18n("Roll %d %s"
				%(i, time.strftime(" %b %d, %Y", time.localtime(latestRoll['ImportDate']))))
		else:
			title = i18n("Import %d"%(i))
			
		print "Adding Roll Album %s"%(title)
		print [self.strLatestRoll, title]

		album = self.__newAlbumFromPath([self.strLatestRoll, title])
		album['Type']="Roll"
		album['W'] = False
		album['KeyList'] = copy.copy(latestRoll['KeyList'])
		
		if len(latestRoll['AlbumList']) > 10:
			latestRoll['AlbumList'].pop(0)
		
		self.emit(PYSIGNAL("addAlbum"),([self.strLatestRoll, title], None))
	
	def importFromSource(self, source):
		# empty 'last roll' album
		self.__rotateRoll()
		lastRoll = self.getAlbum([self.strLatestRoll])
		lastRoll['KeyList'] = []
		lastRoll['ImportDate'] = int(time.time())
		self.emit(PYSIGNAL("updateAlbums"),([[self.strLatestRoll]],None))

		self.thread = LImportThread(self)
		self.thread.setImportObject(source)
		self.thread.start()
		
	def __deleteLinks(self, dir):
		if os.path.isdir(str(dir)):
			files = os.listdir(dir)
			for file in files:
				path = os.path.join(dir, file)
##~ 				print path
				if not os.path.isdir(path) and os.path.islink(path):
					os.remove(path)
		
	def __copyAlbumFilesRecurse(self, albumPath, dir):
		LUtils.ensureDirectory(str(dir))
		keys = self.getAlbum(albumPath)['KeyList']
		for key in keys:
			# create link to real file
			dict = self.getImage(key)
			(p, filename) = os.path.split(dict['ImagePath'])
			linkPath = os.path.join(str(dir), dict['Caption'])
			shutil.copy2(dict['ImagePath'], linkPath)
		albums = self.getAlbum(albumPath)['AlbumList']
		for album in albums:
			newDir = os.path.join(str(dir), album['AlbumName'])
			self.__copyAlbumFilesRecurse(albumPath + [album['AlbumName']], newDir)
		return dir

	def __createAlbumLinksRecurse(self, albumPath):
		dir = self.getAlbumFilesystemPath(albumPath)
		LUtils.ensureDirectory(str(dir))
		self.__deleteLinks(str(dir))
		keys = self.getAlbum(albumPath)['KeyList']
		for key in keys:
			# create link to real file
			dict = self.getImage(key)
			filename = LUtils.buildFilename(dict['Caption'])
			filename = LUtils.findUniqueFilename(dir, filename)
			linkPath = os.path.join(dir, filename)
			print "link",linkPath
			os.symlink(dict['ImagePath'], linkPath)
		albums = self.getAlbum(albumPath)['AlbumList']
		for album in albums:
			self.__createAlbumLinksRecurse(albumPath + [album['AlbumName']])
		return dir
		
	def createAlbumLinks(self, albumPath):
		return self.__createAlbumLinksRecurse(albumPath)
		
	def exportAlbumToFolder(self, albumPath, dir):
		self.__copyAlbumFilesRecurse(albumPath, dir)
		
	def exportKeysToFolder(self, keys, dir):
		LUtils.ensureDirectory(str(dir))
		for key in keys:
			# create link to real file
			dict = self.getImage(key)
			(p, filename) = os.path.split(dict['ImagePath'])
			linkPath = os.path.join(str(dir), filename)
			shutil.copy2(dict['ImagePath'], linkPath)
		
	def moveAlbum(self, dstPath, srcPath):
		# find dst album
		if len(srcPath) == 0:
			return
	
		if LUtils.isListChild(srcPath, dstPath):
			return 
		
		if dstPath:
			dst = self.getAlbum(dstPath)['AlbumList']
		else: 
			dst = self.rootPList[0]['List of Albums']
			
		# check for album with the same name
		name = srcPath[-1]
		newPath = dstPath + [name]		
		for x in dst:
			if x['AlbumName'] == name:
				self.emit(PYSIGNAL("error"), ("An album named '"+str(name)+"' already exists.", None))
				return
					
		srcAlbum = self.removeAlbum(srcPath)
		if srcAlbum:
			dst.append(srcAlbum)
			# move filesystem folder
			self.emit(PYSIGNAL("moveAlbum"), (newPath, srcPath))
							
	def rotateImage(self, key):
		photo = self.getPhoto(key)
		photo.rotate()
		self.fastWrite()

	def rotateCCImage(self, key):
		photo = self.getPhoto(key)
		photo.rotateReverse()
		self.fastWrite()

	def cropImage(self, key, rect):
		photo = self.getPhoto(key)
		photo.crop(rect)
		self.fastWrite()

	def greyScaleImage(self, key):
		photo = self.getPhoto(key)
		photo.grayscale()
			
	def redeyeImage(self, key, rect):
		photo = self.getPhoto(key)
		photo.redeye(rect)
			
	def revertImage(self, key):
		photo = self.getPhoto(key)
		photo.revert()
		self.fastWrite()
		
	def enhanceImage(self, key):
		photo = self.getPhoto(key)
		photo.enhance(True)

	def dateSwap(self, key):
		photo = self.getPhoto(key)
		photo.dateSwap()
			
	def __xmlAtom(self,doc,parent,tag,text):
		obj = doc.createElement(tag)
		parent.appendChild(obj)
		obj.appendChild(doc.createTextNode(str(text)))
		
	def getXMLFromKeys(self, keys, wrapper="Thumbs", title="My Photos"):
		doc = QDomDocument(wrapper)
		root = doc.createElement(wrapper)
		root.setAttribute('version','1.0')
		root.setAttribute('Title',title)
		doc.appendChild(root)
		for key in keys:
			dict = self.getImage(key)
			if dict:
				element = doc.createElement('Photo')
				root.appendChild(element)
				(path, filename) = os.path.split(dict['ImagePath'])
				self.__xmlAtom(doc, element, "Filename", filename)
				self.__xmlAtom(doc, element, "Title", dict.get('Caption'))
				self.__xmlAtom(doc, element, "Rating", dict.get('Rating'))
				self.__xmlAtom(doc, element, "Comments", dict.get('Comments'))
		return str(doc.toString())
		
	def __funcClearScreensaver(self, album):
		album['Screensaver']=False
		
	def __recurseAlbums(self, func, albums = None):
		if albums == None:
			albums = self.rootPList[0]['List of Albums']
		for album in albums:
			func(album)
			childList = album['AlbumList']
			if childList and len(childList):
				self.__recurseAlbums(func, childList)
				
	def __writeTextFile(self, path, lines):
		f = open(path, "w")
		f.writelines(lines)
		f.close()
				
	def __modifyConfigFile(self, path, section, name, value):
		sectionPattern = re.compile(r"\[(.*)\]")
		namePattern = re.compile(r"^([^ ]*) *= *(.*)$")
		lines = []
		try:
			f = open(path,"r")
			lines = f.readlines()
			f.close()
			curSection = None
		except:
			pass
		
		for i in xrange(len(lines)):
			mc = sectionPattern.match(lines[i])
			if mc:
				if curSection == section:
					# we got to the end of the section without finding the line.  Add it here
					lines.insert(i, "%s=%s\n"%(name,value))
					self.__writeTextFile(path, lines)
					return
				else:
					curSection = mc.group(1)
			elif section == curSection:
##~ 				print lines[i]
				mc = namePattern.match(lines[i])
				if mc and mc.group(1) == name:
					lines[i] = "%s=%s\n"%(name,value)
					self.__writeTextFile(path, lines)
					return
		# if we got here then the section wasn't found
		if section:	# don't write 'None' section
			lines.append("[%s]\n"%(section))
		lines.append("%s=%s\n"%(name,value))
		self.__writeTextFile(path, lines)
		

	def setScreensaverAlbum(self, albumPath):
		# mark album properties
		if LUtils.hasOpenGL():
			configFile = "kslidesaverglrc"
			section = None
			name = "imageDirectory"
			cmd = "kslidesavergl.desktop"
##~ 			print "hadGL"
		else:
			configFile = "kslideshow.kssrc"
			section = "Settings"
			name = "Directory"
			cmd = "KSlideshow.desktop"
##~ 			print "noGL"
		album = self.getAlbum(albumPath)
		if album:
			self.__recurseAlbums(self.__funcClearScreensaver)
			album['Screensaver']=True # unmark all other screensaver albums here!
			dir = str(self.__createAlbumLinksRecurse(albumPath))
			# create ~/.kde/share/config/lphoto
			# imageDirectory = $dir
			sConfigPath = str(os.path.join(os.path.expanduser('~'),".kde","share","config",configFile))
			dConfigPath = str(os.path.join(os.path.expanduser('~'),".kde","share","config","kdesktoprc"))
			self.__modifyConfigFile(sConfigPath, section, name, dir)
			self.__modifyConfigFile(dConfigPath, "ScreenSaver", "Saver", cmd)
			self.__modifyConfigFile(dConfigPath, "ScreenSaver", "Enabled", "true")
			os.system("dcop kdesktop KScreensaverIface enable true")
			
	def reorderAlbumKeys(self, albumPath, key, keys):
		album = self.getAlbum(albumPath)
		if key in keys:
			return
		if not(album):
			return
		albumKeys = album['KeyList']
		if key == None:
			self.trashKeyListFromAlbum(album, keys)
			albumKeys.extend(keys)
		else:
			self.trashKeyListFromAlbum(album, keys)
			
			i = albumKeys.index(key)
			a = albumKeys[:i]
			b = albumKeys[i:]
			a.extend(keys)
			a.extend(b)
			album['KeyList'] = a
			
	def getAlbumFilesystemPath(self, albumPath):
		dir = os.path.join(LPhotoLibrary.libraryPath(),"albums")
		for d in albumPath:
			dir = os.path.join(str(dir), str(d))
		return dir
		
	def slotDragSourceImport(self, files):
		# create new album 
		album = self.__newAlbum(self.__getNewAlbumName(), [])
		albumPath = [album['AlbumName']]
		self.rootPList[0]['List of Albums'].append(album)
		self.emit(PYSIGNAL("addAlbum"),(album['AlbumName'], None))
		source = LDragImport(files, albumPath)
		self.emit(PYSIGNAL("dragImport"), (source, None))
		
	def slotDuplicate(self, key, albumPath):
		sc = LWaitCursor()
		# get new key
		newKey = self.__getNewKey(key)
		#duplicate current imageself.getImage(key)
		orig = self.getImage(key)
		dict = copy.deepcopy(orig)
		dir, filename = os.path.split(dict['ImagePath'])
		filename = LUtils.findUniqueFilename(dir, filename)
		dict['ImagePath'] = str(os.path.join(dir, filename))
		dict['ThumbPath'] = str(os.path.join(dir, "Thumbs", filename))
		shutil.copy2(orig['ImagePath'], dict['ImagePath'])
		(w,h) = LUtils.downsizeImage(dict['ImagePath'], dict['ThumbPath'])
		if h==0 or w==0:
			return # no width or height
			
		dict['AspectRatio'] = w/float(h)#LUtils.createThumbnail(photo['ImagePath'], photo['ThumbPath'])
		dict['Width'] = w
		dict['Height'] = h
		albums = self.__addPhotoToAlbumsEvent(newKey, dict, albumPath)
		self.emit(PYSIGNAL("updateAlbums"),([albumPath],None))
		
	def getTotalSize(self, keys):
		total = 0
		for key in keys:			
			p = self.getImage(key)
			stats = os.stat(str(p.get('ImagePath')))
			total = stats[6] + total
		return total
			
	def albumSetOption(self, albumPath, category, key, value):
		album = self.getAlbum(albumPath)
		if album:
			# get options dictionary
			if not album.has_key("Options"):
				options = {}
				album['Options']=options
			else:
				options = album['Options']
			if not options.has_key(category):
				dict = {}
				options[category]=dict
			else:
				dict = options[category]
			dict[key]=value
			print value.__class__
		else:
			print "albumSetOption:",albumPath,"not found"
		
	def albumGetOption(self, albumPath, category, key, default=None):
		album = self.getAlbum(albumPath)
		if not (album and album.has_key("Options")):
			return default
		options = album['Options']
		if not options.has_key(category):
			return default
		dict = options[category]
		if not dict.has_key(key):
			return default
		return dict[key]
		
	def backupAlbum(self, albumPath, savePath):
		# create xml for album keys
		keys = self.getAlbum(albumPath)['KeyList']
		xmls = self.getXMLFromKeys(keys)
		ouf = open(os.path.join(savepath, "album.xml"), mode="w")
		ouf.write(xml)
		ouf.close()
		# create album links
		dir = str(self.__createAlbumLinksRecurse(albumPath))
	
	def serializeAlbumCombo(self, albumPath, widget, category, key, bRestore, default=None):
		if bRestore:
			s = self.albumGetOption(albumPath, category, key, default)
			if s:
				i = widget.listBox().index(widget.listBox().findItem(s))
				if i < 0 and s != default:
					i = widget.listBox().index(widget.listBox().findItem(default))
					if i < 0: i = 0
				widget.setCurrentItem(i)
		else:
			self.albumSetOption(albumPath, category, key, str(widget.currentText()))

	def serializeAlbumEdit(self, albumPath, widget, category, key, bRestore, default=None):
		if bRestore:
			widget.setText(self.albumGetOption(albumPath, category, key, default))
		else:
			self.albumSetOption(albumPath, category, key, str(widget.text()))
	
	def serializeAlbumRange(self, albumPath, widget, category, key, bRestore, default=0):
		if bRestore:
			widget.setValue(int(self.albumGetOption(albumPath, category, key, default)))
		else:
			self.albumSetOption(albumPath, category, key, int(widget.value()))

	def serializeAlbumCheckBox(self, albumPath, widget, category, key, bRestore, default=None):
		if bRestore:
			widget.setChecked(self.albumGetOption(albumPath, category, key, default))
		else:
			self.albumSetOption(albumPath, category, key, widget.isChecked())

	def serializeAlbumRadioGroup(self, albumPath, widgets, category, key, bRestore, default=0):
		if bRestore:
			widgets[int(self.albumGetOption(albumPath, category, key, default))].setChecked(True)
		else:
			for i, widget in enumerate(widgets):
				if widget.isChecked():
					self.albumSetOption(albumPath, category, key, str(i))
					break
			
			
		
