#
# "@(#) $Id: shellprocess.py,v 1.2 2004/12/10 01:23:21 will Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
import re, time

class LShellProcess(KShellProcess):
	def __init__(self):
		KProcess.__init__(self)
		QObject.connect(self,SIGNAL("processExited(KProcess *)"),self.endProcess)
		QObject.connect(self,SIGNAL("receivedStdout(KProcess *,char *,int)"),self.gotOutput)
		QObject.connect(self,SIGNAL("receivedStderr(KProcess *,char *,int)"),self.gotOutput)
		self.buffer = ""
		self.convertLineEndings = False
		self.lastTime = 0
		self.interrupted = False

	def buildCommand(self):
		self.blah("Must override!")
	
	def lineSplitPattern(self):
		return r'\n*'
	
	def lineEnding(self):
		return '\n'
	
	def preprocessBuffer(self,buffer):
		if self.convertLineEndings:
			buffer = re.sub("\r","\n",buffer)
		return buffer

	def gotOutput(self,process,buffer,bufferLen):
		self.buffer = self.buffer+self.preprocessBuffer(buffer[:bufferLen])
		lines = re.split(self.lineSplitPattern(),self.buffer)
		partial = self.buffer[-1:]!=self.lineEnding()
		while len(lines)>0:
			if len(lines[-1])==0:
				lines = lines[:-1]
			else: break
		lineCount = len(lines)
		if lineCount>1:
			if partial:
				self.buffer = lines[lineCount-1]
				lines = lines[:-1]
			else:
				self.buffer = ""
			self.processLines(lines)

	def processLines(self,lines):
		pass

	def run(self):
		self.buildCommand()
		self.start(KProcess.NotifyOnExit,KProcess.AllOutput)

	def endProcess(self,process):
		if self.normalExit():
			self.emit(PYSIGNAL("done"),(self,None))
		else:
			self.emit(PYSIGNAL("abort"),(self,None))

	def abortProcess(self,process):
		self.emit(PYSIGNAL("abort"),(self,None))

	def maybeEmitEvent(self,status):
		now = long(time.time())
		if now!=self.lastTime:
			self.emitEvent(status)
			self.lastTime = now

	def emitEvent(self,status):
		self.emit(PYSIGNAL('status'),(self,status))

	def kill(self):
		self.interrupted = True
		KProcess.kill(self)
		
class LProcessQueue(QObject):
	# processList = [ {'label':"", 'process':lambda..., 'postlabel':"", cleanup:lambda...} ]
	
	def __init__(self, processList):
		QObject.__init__(self)
		self.it = None
		self.processList = processList
		self.item = None
		
	def run(self):
		if not self.it:
			self.it = iter(self.processList)
			self.advanceProcess()
		
	def advanceProcess(self):
		if self.item and self.item.has_key('cleanup'): 
			self.item['cleanup']()
		
		try:
			self.item = self.it.next()
		except StopIteration:
			self.emit(PYSIGNAL("complete"),(None, None))
			return
			
		print "ADVANCEPROCESS",self.item['label']
		self.emit(PYSIGNAL("newstep"), (self.item['label'], 0))
		self.emit(PYSIGNAL("status"), (1,100))
		self.p = self.item['process']()		
		QObject.connect(self.p, PYSIGNAL("status"), self.statusForward)
		QObject.connect(self.p, PYSIGNAL("done"), self.advanceProcess)
		QObject.connect(self.p, PYSIGNAL("abort"), self.abort)
		self.p.run()
		
	def statusForward(self, step, max):
		self.emit(PYSIGNAL("status"), (step, max))
		if step == max and self.item.has_key('postlabel'):
			self.emit(PYSIGNAL("newstep"), (self.item['postlabel'], 0))
			
	def abort(self):
		print "ProcessQueue Abort"
		self.emit(PYSIGNAL("abort"), (0,0))
		
	def kill(self):
		if self.p:
			self.p.kill()
			
	
