/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef __SCREEN_H
#define __SCREEN_H

#include "snipes.h"

int screen_init( enum DisplayType mode );
void screen_close( void );
void screen_getmaxyx( int *maxy, int *maxx );

void screen_cursor_on( void );
void screen_cursor_off( void );
void screen_scroll_on( void );
void screen_scroll_off( void );
void screen_getyx( int *my_y, int *my_x );

void screen_clear( void );
void screen_refresh( void );
void screen_setcolorpair( int n );
void screen_setnormalattr( void );

void screen_move( int y, int x );
void screen_addch( unsigned char ch );
void screen_mvaddch( int y, int x, unsigned char ch );
void screen_addstr( char *str );
void screen_mvaddstr( int y, int x, char *str );


#ifdef USE_XWIN
void set_okay_to_draw_X( void );
#endif

#endif
