#
# "@(#) $Id: AIFFTrack.py,v 1.4 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from Track import *
import aifc, os

class AIFFTrack(FileTrack):
	def __init__(self,library = None):
		FileTrack.__init__(self,library)
	
	def setFile(self,filePath,thread = None):
		if type(filePath).__name__=='unicode':
			filePath = filePath.encode('latin-1')
		FileTrack.setFile(self,filePath,thread)
		(rootName,ext) = os.path.splitext(filePath)
		if ext=='aiff':
			self.kind = "AIFF audio file"
			self.format = "Audio Interchange File Format"
		else:
			self.kind = "AIFC audio file"
			self.format = "AIFF Compressed"
		fd = aifc.open(filePath,"rb")
		(numChannels,sampleWidth,frameRate,numFrames,compressionType,compressionName) = fd.getparams()
		self.channels = numChannels
		self.sampleRate = frameRate
		self.totalTime = numFrames*numChannels*sampleWidth*1000/frameRate
		fd.close()
