#
# "@(#) $Id: LAudioCDView.py,v 1.11 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LTrackDrag import *
from LAudioCDViewItem import *
from CDLibrary import *
from CDROM import *
from LTrackView import *
from LMusicRipper import *
from LSettings import *

class LAudioCDView(LTrackView,KListView):
	def __init__(self,container,library):
		LTrackView.__init__(self)
		KListView.__init__(self,container,"audiocd")
		self.settings = LSettings.settings()
		self.library = library
		self.playlist = self.library.playlistWithName("CD")
		self.setSelectionMode(QListView.Extended)
		self.setAllColumnsShowFocus(True)
		self.loadHeaders()
		c = QColor(237,243,254)
		self.setAlternateBackground(c)
		self.loadTrackItems()
		self.cd = self.library.drive
		QObject.connect(self.cd,PYSIGNAL("cdInserted"),self.refresh)
		QObject.connect(self,SIGNAL('selectionChanged()'),self.doSelectionChanged)
		QObject.connect(self,SIGNAL("contextMenuRequested(QListViewItem *, const QPoint &, int)"),self.contextMenu)

	def loadHeaders(self):
		headers = [" "," ",i18n("Song Name"),i18n("Time"),i18n("Artist"),i18n("Album"),i18n("Genre")]
		widths = [40,25,220,40,120,180,80]
		for index in xrange(0,len(headers)):
			self.addColumn(headers[index],widths[index])
		self.setShowSortIndicator(True)
		self.setFullWidth(True)
		sortColumn = self.settings.get('CD Library Sort Column',1)
		sortAscending = self.settings.get('CD Library Sort Ascending',True)
		self.setSorting(sortColumn,sortAscending)
		QObject.connect(self.header(),SIGNAL("indexChange(int,int,int)"),self.columnIndexChanged)
		QObject.connect(self.header(),SIGNAL("sizeChange(int,int,int)"),self.columnSizeChanged)
		self.loadHeaderSizes('CD Library Header Widths')
		self.loadHeaderOrdering('CD Library Header Map')

	def loadTrackItem(self,track):
		LAudioCDViewItem(self,track)

	def anyItemsSelected(self):
		item = self.firstChild()
		while item:
			if item.isSelected():
				return True
			item = item.itemBelow()
		return False

	def firstSelectedItem(self):
		item = self.firstChild()
		while item:
			if item.isSelected():
				return item
			item = item.itemBelow()
		return None

	def loadTrackItems(self):
		self.clear()
		tracks = self.library.tracks()
		for trackKey in tracks.keys():
			track = tracks[trackKey]
			if self.matchesSearch(track):
				self.loadTrackItem(tracks[trackKey])
		self.emitCurrentEnabledSortedTracks()
		self.emit(PYSIGNAL("changed"),(self,None))

	def refresh(self):
		self.loadTrackItems()
	
	def contentsMouseDoubleClickEvent(self,event):
		pos = self.contentsToViewport(event.pos())
		item = self.itemAt(pos)
		if item:
			item.contentsMouseDoubleClickEvent(event)

	def selectedTrackIDs(self):
		result = []
		item = self.firstChild()
		while item:
			if item.isSelected():
				result.append(item.trackID())
			item = item.itemBelow()
		return result

	def selectedTracks(self):
		result = []
		item = self.firstChild()
		while item:
			if item.isSelected():
				result.append(item.track())
			item = item.itemBelow()
		return result
	
	def allTracks(self):
		result = []
		item = self.firstChild()
		while item:
			result.append(item.track())
			item = item.itemBelow()
		return result

	def selectAll(self,select):
		item = self.firstChild()
		while item:
			if item.isSelected()!=select:
				self.setSelected(item,select)
			item = item.itemBelow()
		#self.repaint()

	def dragObject(self):
		selectedTracks = self.selectedTrackIDs()
		drag = LTrackDrag(str(selectedTracks),self)
		drag.dragCopy()
	
	def canImport(self):
		return True

	def doImport(self):
		tracks = self.enabledUnrippedTracks()
		if len(tracks)>0:
			LMusicRipper.singleton().ripTracks(tracks)

	def enabledUnrippedTracks(self):
		result = []
		item = self.firstChild()
		while item:
			track = item.track()
			if track.enabled and track.ripStatus=='idle':
				result.append(track)
			item = item.itemBelow()
		return result

	def canExport(self):
		return False
	
	def canBurn(self):
		return False

	def doSelectionChanged(self):
		self.emit(PYSIGNAL("selectionChanged"),(None,None))
		if self.anyItemsSelected():
			LMusicPlayer.selectedTrack()

	def setSorting(self,column,ascending):
		KListView.setSorting(self,column,ascending)
		self.settings['CD Library Sort Column'] = column
		self.settings['CD Library Sort Ascending'] = not not ascending
		self.emitCurrentEnabledSortedTracks()

	def canPlay(self):
		return True
	
	def canGetInfo(self):
		return True
	
	def play(self):
		item = self.firstSelectedItem()
		if item:
			#print "playing selected item"
			item.track().play(self.playlist)
		else:
			#print "playing some item"
			LMusicPlayer.playItemFrom(self.library,self.playlist)

	def clear(self):
		item = self.firstChild()
		while item:
			item.die()
			item = item.itemBelow()
		KListView.clear(self)

	def columnIndexChanged(self,section,fromIndex,toIndex):
		self.saveHeaderOrdering('CD Library Header Map')
	
	def columnSizeChanged(self,section,oldSize,newSize):
		self.saveHeaderSizes('CD Library Header Widths')

	def canDelete(self):
		return False
	
	def canEject(self):
		return True
	
	def eject(self):
		return self.library.eject()

	def contextMenu(self,item,pos,col):
		if item:
			item.contextMenu(pos,col)

	def setSearchType(self,searchType):
		self.searchType = searchType
		self.loadTrackItems()

	def setSearchText(self,searchText):
		self.searchText = searchText
		self.loadTrackItems()
