#
# "@(#) $Id: LBarberPoleView.py,v 1.4 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LsongsPaths import *

class LBarberPoleView(QWidget):
	def __init__(self,container):
		QWidget.__init__(self,container)
		self.bumper = 0
		self.timer = QTimer()
		QObject.connect(self.timer,SIGNAL("timeout()"),self.bump)
		self.size = 10
		self.count = 10
		self.timer.start(250)
		self.setFixedSize(QSize(self.size*2*self.count-self.size,self.size))
	
	def bump(self):
		self.bumper = (self.bumper+1) % self.count
		self.repaint()

	def paintEvent(self,ev):
		p = QPainter()
		p.begin(self)
		r = self.rect()
		side = r.height()
		for i in range(0,self.count):
			sq = QRect(i*side*2,0,side,side)
			# drop shadow
			r1 = QRect(sq.left()+1,sq.top()+1,sq.width()-1,sq.height()-1)
			p.setPen(QColor(132,151,198))
			p.drawRect(r1)
			# indicator
			if i==self.bumper:
				r2 = QRect(sq.left()+1,sq.top()+1,sq.width()-1,sq.height()-2)
				fill = QBrush(QColor(80,80,80))
				p.fillRect(r2,fill)
			# bounding box
			r1 = QRect(sq.left(),sq.top(),sq.width()-1,sq.height()-1)
			p.setPen(QColor(21,21,19))
			p.drawRect(r1)
		p.end()
