#
# "@(#) $Id: LCheckListViewItem.py,v 1.3 2004/07/21 17:54:18 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
#
# a subclass of QCheckListItem that supports alternating colors
# like KListViewItem
#
class LCheckListViewItem (QCheckListItem):
	def __init__(self,container = None,name = "",theType=QCheckListItem.CheckBox):
		QCheckListItem.__init__(self,container,name,theType)
		self.m_known = False
		self.m_odd = False
	
	def backgroundColor(self):
		if self.isAlternate():
			return self.listView().alternateBackground()
		return self.listView().viewport().colorGroup().base()

	def isAlternate(self):
		lv = self.listView()
		if lv and lv.alternateBackground():
			above = self.itemAbove()
			self.m_known = True
			if above:
				self.m_known = above.m_known
			if self.m_known:
				if above:
					self.m_odd = not above.m_odd
				else:
					self.m_odd = False
			else:
				previous = True
				if self.parent():
					item = self.parent()
					if item:
						previous = item.m_odd
					item = self.parent().firstChild()
				else:
					item = lv.firstChild()
				while item:
					item.m_odd = previous
					previous = not previous
					item.m_known = True
					item = item.nextSibling()
			return self.m_odd
		return False
	
	def paintCell(self,p,cg,column,width,alignment):
		pm = None #self.listView().viewport().backgroundPixmap()
		_cg = QColorGroup(cg)
		if pm and not pm.isNull():
			_cg.setBrush(QColorGroup.Base,QBrush(self.backgroundColor(),pm))
			p.setBrushOrigin(-self.listView().contentsX(),-self.listView.contentsY())
		else:
			if self.isAlternate():
				if self.listView().viewport().backgroundMode()==Qt.FixedColor:
					_cg.setColor(QColorGroup.Background,self.listView().alternateBackground())
				else:
					_cg.setColor(QColorGroup.Base,self.listView().alternateBackground())
		QCheckListItem.paintCell(self,p,_cg,column,width,alignment)
		
