#
# LEncoderSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from qt import *
from LSourceViewItem import *
from EncoderLibrary import *
from LMusicEncoder import *
from LSettings import *

#
# Encoder queue
#
class LEncoderSourceViewItem(LSourceViewItem):
	def __init__(self,container):
		name = i18n("Encoder")
		LSourceViewItem.__init__(self,container,name)
		self.library = EncoderLibrary.singleton()
		self.source = self.library.playlistWithName('Encoder')
		self.encoder = LMusicEncoder.singleton()
		self.settings = LSettings.settings()

	def makeKey(self):
		return 'K'

	def iconFileName(self): return "sourceencoding.png"

	def select(self,container):
		container.emit(PYSIGNAL("selectEncoder"),(self.library,None))

	def buildPopup(self,mainWindow):
		self.popup = QPopupMenu()
		self.queueItem = self.popup.insertItem(i18n("Pause Encoding"),self.startStopQueue)
	
	def loadPopup(self):
		if self.encoder.isEncoding():
			self.popup.changeItem(self.queueItem,i18n("Pause Encoding"))
		else:
			self.popup.changeItem(self.queueItem,i18n("Resume Encoding"))
		
	def startStopQueue(self):
		if self.encoder.isEncoding():
			self.settings['Encoding'] = False
			self.encoder.killEncoder()
		else:
			self.settings['Encoding'] = True
			self.encoder.encodeNextTrack()
	
	def clearQueue(self):
		print "clear queue"
