#
# "@(#) $Id: LMusicDellExporter.py,v 1.4 2004/12/06 21:23:12 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
import re
from LsongsProcess import *
from utils import *

def _get(a,b=''):
	if a==None: return b
	return a

class LMusicDellExporterProcess(LsongsProcess):
	def __init__(self,track,index,count):
		LsongsProcess.__init__(self)
		self.track = track
		self.index = index
		self.count = count
		self.pattern = re.compile(r"\|(\d+)\|(\d+)\|")

	def buildCommand(self):
		self.setExecutable('nice')
		args = ['njbputtrack',self.track.location,
			'-t', unikode(_get(self.track.title,"Unknown Title")).encode('latin-1'),
			'-a', unikode(_get(self.track.artist,"Unknown Artist")).encode('latin-1'),
			'-l', unikode(_get(self.track.album,"Unknown Album")).encode('latin-1'),
			'-c', "MP3",
			'-g', unikode(_get(self.track.genre,"Unknown")).encode('latin-1'),
			'-n', str(_get(self.track.trackNum,0)),
			'-d', str(self.track.totalTime/1000)]
		self.setArguments(args)
		#print map(lambda x: unikode(x).encode('latin-1'),self.args())
		self.emitEvent({'Source':'DellExporter','Status':'BeginTrack','Track':self.track,'Index':self.index,'Count':self.count})
	
	def processLines(self,lines):
		line = lines[-1]
		mo = self.pattern.match(line)
		if mo:
			currentTime = long(mo.group(1))
			totalTime = long(mo.group(2))
			fraction = (currentTime*1.0)/totalTime
			self.maybeEmitEvent({'Source':'DellExporter','Status':'Exporting','currentTime':(self.index+fraction),'totalTime':self.count,'Track':self.track})
	
	def endProcess(self,process):
		self.emitEvent({'Source':'DellExporter','Status':'EndTrack','Track':self.track})
		LsongsProcess.endProcess(self,process)

	def abortProcess(self,process):
		self.emitEvent({'Source':'DellExporter','Status':'EndTrack','Track':self.track,'Interrupted':True})
		LsongsProcess.abortProcess(self,process)

class LMusicDellExporter(QObject):
	def __init__(self):
		QObject.__init__(self)
		self.tracksToExport = []
		self.count = 0
		self.index = 0
		self.process = None

	def exportNextTrack(self):
		if (self.process==None or not self.process.isRunning()):
			if len(self.tracksToExport)>0:
				if self.index==0:
					self.gotStatus(None,{'Source':'DellExporter','Status':'Begin'})
				track = self.tracksToExport[0]
				self.tracksToExport = self.tracksToExport[1:]
				self.process = LMusicDellExporterProcess(track,self.index,self.count)
				QObject.connect(self.process,PYSIGNAL("done"),self.endExportTrack)
				QObject.connect(self.process,PYSIGNAL("status"),self.gotStatus)
				self.process.run()
				self.index = self.index+1
			else:
				self.gotStatus(None,{'Source':'DellExporter','Status':'End'})
		else:
			print "exporting is busy!"
	
	def gotStatus(self,process,status):
		self.emit(PYSIGNAL('status'),(status,None))

	def endExportTrack(self,process):
		if not process.interrupted:
			self.exportNextTrack()
	
	def exportTracks(self,tracks):
		if tracks and len(tracks)>0:
			if len(self.tracksToExport)==0:
				self.index = 0
				self.count = 0
			self.tracksToExport.extend(tracks)
			self.count = self.count+len(tracks)
			self.exportNextTrack()

	def kill(self):
		self.tracksToExport = []
		if self.process:
			self.process.kill()
			self.process = None
			self.gotStatus(None,{'Source':'DellExporter','Status':'End'})

	def static_killCurrentDellExporter():
		LMusicDellExporter.singleton.kill()
	killCurrentDellExporter = staticmethod(static_killCurrentDellExporter)

	def static_singleton():
		global _dellExporterSingleton
		return _dellExporterSingleton

	singleton = staticmethod(static_singleton)

_dellExporterSingleton = LMusicDellExporter()
