#
# LPodInfoDialog.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from human import *

class LPodInfoDialog(KDialogBase):
	def __init__(self,library):
		KDialogBase.__init__( self, None, "podinfodialog", True, library.name, KDialogBase.Ok, KDialogBase.Ok, True )
		self.library = library
		self.build()
		self.setMinimumWidth(250)
		self.adjustSize()
		self.setFixedSize(self.size())

	def build(self):
		page = QWidget(self)
		self.setMainWidget(page)
		layout = QVBoxLayout(page)
		self.buildItems(page,layout)
	
	def buildItems(self,container,containerLayout):
		containerLayout.addWidget(QLabel("<b>Mount Point:</b>&nbsp;%s" % self.library.basePath,container))
		containerLayout.addWidget(QLabel("<b>Database Version:</b>&nbsp;%s" % self.library.dbVersion(),container))
		(used,free,total) = self.library.usage()
		#print used,free,total
		percent = int(used*100.0/total+0.5)
		containerLayout.addWidget(QLabel("<b>Total:</b>&nbsp;%s KB " % humanComma(total/1024),container))
		containerLayout.addWidget(QLabel("<b>Used:</b>&nbsp;%s KB (%d%%)" % (humanComma(used/1024),percent),container))
		containerLayout.addWidget(QLabel("<b>Free:</b>&nbsp;%s KB (%d%%)" % (humanComma(free/1024),100-percent),container))
