#
# "@(#) $Id: LRadioTrackDialog.py,v 1.4 2004/08/04 01:01:47 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from musicgenres import *
from utils import *

class LRadioTrackDialog(KDialogBase):
	def __init__(self,plist = None):
		caption = i18n("Add a new Station")
		KDialogBase.__init__( self, None, "newradiodialog", True, caption, KDialogBase.Ok+KDialogBase.Cancel, KDialogBase.Ok, True )
		self.build()
		self.load(plist)
		self.adjustSize()
		s = self.size()
		s.setWidth(s.width()*2)
		self.setMinimumSize(s)
	
	def build(self):
		page = QWidget(self)
		self.setMainWidget(page)
		layout = QVBoxLayout(page)
		self.buildItems(page,layout)
	
	def buildSimpleEditItem(self,name,labelText,container,containerLayout):
		layout = QVBoxLayout()
		containerLayout.addLayout(layout)
		label = QLabel(u"<b>%s</b>" % unikode(labelText),container)
		layout.addWidget(label)
		editName = name+"Edit"
		editItem = KLineEdit("",container)
		self.__dict__[editName] = editItem
		layout.addWidget(editItem)

	def buildBitRateEditItem(self,name,labelText,container,containerLayout):
		layout = QVBoxLayout()
		containerLayout.addLayout(layout)
		label = QLabel(u"<b>%s</b>" % unikode(labelText),container)
		layout.addWidget(label)
		hlayout = QHBoxLayout()
		layout.addLayout(hlayout)
		editName = name+"Edit"
		editItem = KRestrictedLine(container,"","0123456789")
		self.__dict__[editName] = editItem
		hlayout.addWidget(editItem)
		label = QLabel(i18n("  (ex. 128000)"),container)
		hlayout.addWidget(label)

	def buildGenreItem(self,container,containerLayout):
		layout = QVBoxLayout()
		containerLayout.addLayout(layout)
		label = QLabel(u"<b>%s</b>"% unikode(i18n("Genre")),container)
		layout.addWidget(label)
		hlayout = QHBoxLayout()
		layout.addLayout(hlayout)
		self.genreEdit = KComboBox(False,container)
		sortedGenres = musicGenres[:]
		sortedGenres.sort()
		for genre in sortedGenres:
			self.genreEdit.insertItem(genre)
		hlayout.addWidget(self.genreEdit,2)
		hlayout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))

	def buildItems(self,container,containerLayout):
		self.buildSimpleEditItem("name",i18n("Name"),container,containerLayout)
		self.buildSimpleEditItem("description",i18n("Description"),container,containerLayout)
		self.buildBitRateEditItem("bitRate",i18n("Bit Rate"),container,containerLayout)
		self.buildGenreItem(container,containerLayout)
		self.buildSimpleEditItem("url",i18n("Stream URL"),container,containerLayout)
		self.explicitEdit = QCheckBox(i18n("Explicit Content"),container)
		containerLayout.addWidget(self.explicitEdit)

	def load(self,plist):
		if plist:
			self.nameEdit.setText(plist['Title'])
			self.descriptionEdit.setText(plist['Description'])
			self.bitRateEdit.setText(str(plist['Bit Rate']))
			self.genreEdit.setCurrentText(plist['Genre'])
			self.urlEdit.setText(plist['Location'])
			self.explicitEdit.setChecked(plist['Explicit'])
	
	def unload(self):
		item = {}
		item['Title'] = unicode(self.nameEdit.text())
		item['Description'] = unicode(self.descriptionEdit.text())
		try: item['Bit Rate'] = int(str(self.bitRateEdit.text()))
		except: item['Bit Rate'] = 128000
		item['Genre'] = str(self.genreEdit.currentText())
		item['Location'] = str(self.urlEdit.text())
		item['Explicit'] = self.explicitEdit.isChecked()
		#item['User'] = True
		return item
