#
# "@(#) $Id: LSearchWidget.py,v 1.5 2004/07/26 16:46:23 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LPixmapPushButton import *
from LsongsPaths import *
from utils import *

_labels = None


class LSearchWidget(QWidget):
	def __init__(self,container=None):
		QWidget.__init__(self,container)
		global _labels
		if _labels==None:
			_labels = { 'all':i18n('Search'), 'artists':i18n('Search Artists'), 'albums':i18n('Search Albums'), 'composers':i18n('Search Composers'), 'titles':i18n('Search Songs'), 'genres':i18n('Search Genres')}
		self.searchType = 'all'
		self.searchText = ''
		self.initActions()
		self.initMenu()
		self.initViews()

	def initActions(self):
		self.collection = KActionCollection(self)
		self.searchAllAction = KRadioAction(i18n("&All"),KShortcut.null(),self.slotSearchAll,self.actionCollection(),"searchAll")
		self.searchArtistsAction = KRadioAction(i18n("A&rtists"),KShortcut.null(),self.slotSearchArtists,self.actionCollection(),"searchArtists")
		self.searchAlbumsAction = KRadioAction(i18n("A&lbums"),KShortcut.null(),self.slotSearchAlbums,self.actionCollection(),"searchAlbums")
		self.searchComposersAction = KRadioAction(i18n("&Composers"),KShortcut.null(),self.slotSearchComposers,self.actionCollection(),"searchComposers")
		self.searchTitlesAction = KRadioAction(i18n("&Songs"),KShortcut.null(),self.slotSearchTitles,self.actionCollection(),"searchTitles")
		self.searchGenresAction = KRadioAction(i18n("&Genres"),KShortcut.null(),self.slotSearchGenres,self.actionCollection(),"searchGenres")
		self.searchAllAction.setExclusiveGroup("search")
		self.searchArtistsAction.setExclusiveGroup("search")
		self.searchAlbumsAction.setExclusiveGroup("search")
		self.searchComposersAction.setExclusiveGroup("search")
		self.searchTitlesAction.setExclusiveGroup("search")
		self.searchGenresAction.setExclusiveGroup("search")

		#
		# XXX DSM pull from settings?
		#
		self.searchAllAction.setChecked(True)

	def actionCollection(self):
		return self.collection

	def initMenu(self):
		self.searchTypeMenu = QPopupMenu()
		self.searchTypeMenu.insertItem(i18n('Search'),0)
		self.searchTypeMenu.setItemEnabled(0,False)
		self.searchTypeMenu.insertSeparator()
		self.searchAllAction.plug(self.searchTypeMenu)
		self.searchArtistsAction.plug(self.searchTypeMenu)
		self.searchAlbumsAction.plug(self.searchTypeMenu)
		self.searchComposersAction.plug(self.searchTypeMenu)
		self.searchTitlesAction.plug(self.searchTypeMenu)
		self.searchGenresAction.plug(self.searchTypeMenu)

	def initViews(self):
		vlayout = QVBoxLayout(self)
		vlayout.setSpacing(4)
		vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))
		layout = QHBoxLayout()
		layout.setSpacing(2)
		vlayout.addLayout(layout,0)
		self.searchTypeButton = LSmallPixmapPushButton(QIconSet(QPixmap(art("buttonsearch.png"))),"",self)
		self.searchTypeButton.setFixedSize(QSize(28,22))
		#self.searchTypeButton.setPopup(self.searchTypeMenu)
		QToolTip.add(self.searchTypeButton,i18n("Quickly find songs, artists and albums"))
		QObject.connect(self.searchTypeButton,SIGNAL("clicked()"),self.slotSearchType)
		layout.addWidget(self.searchTypeButton)
		self.searchTextEdit = QLineEdit(self)
		QObject.connect(self.searchTextEdit,SIGNAL("textChanged(const QString &)"),self.setSearchText)
		QObject.connect(self.searchTextEdit,SIGNAL("returnPressed()"),self.searchReturnPressed)
		layout.addWidget(self.searchTextEdit)
		self.searchLabel = QLabel(i18n("Search"),self)
		self.searchLabel.setAlignment(Qt.AlignCenter)
		vlayout.addWidget(self.searchLabel)
		vlayout.addItem(QSpacerItem(1,1,QSizePolicy.Fixed,QSizePolicy.Expanding))

	def setSearchType(self,value):
		global _labels
		self.searchType = value
		#print "setting searchType to",value
		self.emit(PYSIGNAL("setSearchType"),(self.searchType,None))
		self.searchLabel.setText(_labels[value])

	def slotSearchAll(self):
		self.setSearchType('all')

	def slotSearchArtists(self):
		self.setSearchType('artists')

	def slotSearchAlbums(self):
		self.setSearchType('albums')

	def slotSearchComposers(self):
		self.setSearchType('composers')

	def slotSearchTitles(self):
		self.setSearchType('titles')
	
	def slotSearchGenres(self):
		self.setSearchType('genres')

	def slotSearchType(self):
		self.searchTypeMenu.exec_loop(QCursor.pos())

	def setSearchText(self,text):
		newText = unikode(text).strip()
		if newText!=self.searchText:
			self.searchText = newText
			self.emit(PYSIGNAL("setSearchText"),(self.searchText,None))
		#print "match text is ",self.searchText

	def searchReturnPressed(self):
		if len(self.searchText)>0:
			self.emit(PYSIGNAL("searchWithTextAndType"),(self.searchText,self.searchType))
