#
# LSharedPlaylistSourceViewItem.py
#
# This work is released under the GNU GPL, version 2 or later.
#

from LSourceViewItem import *
from LRemotePlaylistDrag import *
from LTrackDrag import *
from utils import *
#
# Shared playlist (individual)
#
class LSharedPlaylistSourceViewItem(LSourceViewItem):
	def __init__(self,container,playlist):
		self.playlist = playlist
		self.name = playlist.name
		LSourceViewItem.__init__(self,container,self.name)
		self.hasContextMenu = False
		self.setDragEnabled(True)
		self.setDropEnabled(True)

	def makeKey(self):
		if self.playlist.master: return "A"
		else: return u'B %s'+unikode(self.name)

	def iconFileName(self):
		if self.playlist.master: return "sourcelibrary.png"
		else: return "sourceplaylist.png"

	def buildPopup(self,mainWindow):
		pass

	def select(self,container):
		container.emit(PYSIGNAL("selectSharedPlaylist"),(self.playlist,None))

	def createDrag(self,container):
		return LRemotePlaylistDrag(self.playlist,container)

	def acceptDrag(self,event):
		if self.playlist._library.allowWrites:
			if LTrackDrag.canDecode(event): return True
		return False
	
	def dropped(self,event):
		if LTrackDrag.canDecode(event):
			#print "remote playlist accepting track"
			drag = LTrackDrag.decode(event)
			#print "playlist got",drag
			library = Library.mainLibrary()
			trackIDs = drag['TrackIDs']
			tracks = library.tracksWithTrackIDs(trackIDs)
			#print "uploading",tracks,"to",self.playlist.name
			self.playlist.uploadTracks(tracks)
