#
# LSpeedWidget.py
#
# This work is released under the GNU GPL, version 2 or later.
#
from qt import *
from LMusicPlayer import *
from LsongsPaths import *
from LSettings import *

_s_offset_owner = None
_s_offset = 0

class LSpeedSlider(QSlider):
	def wheelEvent(self,e):
		global _s_offset_owner, _s_offset
		if ( e.orientation() != self.orientation() and  not self.rect().contains(e.pos()) ):
			return

		if (_s_offset_owner != self):
			_s_offset_owner = self
			_s_offset = 0
		_s_offset = _offset-e.delta()*max(self.pageStep(),self.lineStep())/120
		if (abs(_s_offset)<1):
			return
		self.setValue( self.value() - int(_s_offset) )
		_s_offset = _s_offset-int(_s_offset)
		e.accept()

class LSpeedWidget(QWidget):
	def __init__(self,container = None):
		QWidget.__init__(self,container)
		self.buildControls()
		speed = LSettings.settings().get('Speed',100)
		self.speedSlider.setValue(speed)
	
	def buildControls(self):
		hbox = QHBoxLayout(self)
		hbox.setSpacing(4)
		hbox.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		label = QLabel("-",self)
		hbox.addWidget(label)
		self.speedSlider = LSpeedSlider(Qt.Horizontal,self)
		self.speedSlider.setFixedWidth(100)
		self.speedSlider.setRange(0,200)
		QObject.connect(self.speedSlider,SIGNAL("valueChanged(int)"),self.speedChanged)
		hbox.addWidget(self.speedSlider)
		label = QLabel("+",self)
		hbox.addWidget(label)
		hbox.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
		QObject.connect(LMusicPlayer.singleton(),PYSIGNAL("speedChanged"),self.gotSpeedChange)

	def speedChanged(self,speed):
		LMusicPlayer.singleton().setSpeed(speed,self)
	
	def gotSpeedChange(self,speed,fromObject):
		if fromObject!=self:
			self.speedSlider.blockSignals(True)
			self.speedSlider.setValue(volume)
			self.speedSlider.blockSignals(False)
	
