#
# "@(#) $Id: LWebStationView.py,v 1.3 2004/08/18 20:19:51 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from kdeemul import *
from LTrackView import *
from LsongsPaths import *
from utils import *
from LRadioLibrary import *
from LMusicPlayer import *
#import PLS

class LWebStationView(QVBox):
	def __init__(self,container):
		QVBox.__init__(self,container)
		self.setSpacing(2)
		self.buildViews()

	def buildViews(self):
		self.buildNavBar()
		self.buildBrowser()

	def buildNavBar(self):
		bar = QWidget(self)
		layout = QHBoxLayout(bar)
		layout.setSpacing(5)
		bSize = QSize(28,22)
##~ 		self.backButton = QPushButton(QIconSet(QPixmap(art("buttonback.png"))),"",bar)
##~ 		self.backButton.setFixedSize(bSize)
##~ 		layout.addWidget(self.backButton)
##~ 		self.forwardButton = QPushButton(QIconSet(QPixmap(art("buttonforward.png"))),"",bar)
##~ 		self.forwardButton.setFixedSize(bSize)
##~ 		layout.addWidget(self.forwardButton)
		self.homeButton = QPushButton(QIconSet(QPixmap(art("buttonhome.png"))),"",bar)
		self.homeButton.setFixedSize(bSize)
		layout.addWidget(self.homeButton)
		layout.addItem(QSpacerItem(1,1,QSizePolicy.Expanding,QSizePolicy.Fixed))
##~ 		QObject.connect(self.backButton,SIGNAL("released()"),self.back)
##~ 		QObject.connect(self.forwardButton,SIGNAL("released()"),self.forward)
		QObject.connect(self.homeButton,SIGNAL("released()"),self.home)

	def buildBrowser(self):
		from khtml import KHTMLPart
		self.browser = KHTMLPart(self)
		self.connect(self.browser.browserExtension(),SIGNAL("openURLRequest(const KURL &, const KParts::URLArgs &)"),self.doRequest)
		self.home()

	def doRequest(self,kurl,args = None):
		path = unikode(kurl.url())
		if path[:4]=='aim:':
			return
		print path
		(root,ext) = os.path.splitext(path)
		if ext=='.pls':
			self.playPLS(kurl)
		else:
			if args:
				self.browser.browserExtension().setURLArgs(args)
			self.browser.openURL(kurl)

	def playPLS(self,kurl):
		print "got PLS link",kurl.url()
		track = RadioTrack()
		track.title = 'Lsongs'
		track.location = str(kurl.url())
		track.isStream = True
		LMusicPlayer.playTrack(track)
		
	def fetchPLS(self,kurl):
		pls = PLS.fetchAndParsePLS(str(kurl.url()))
		print pls

	def home(self):
		self.doRequest(KURL("http://www.shoutcast.com"))

	def back(self):
		KMessageBox.error(self,"Stations 'back' not implemented","Not Implemented")

	def forward(self):
		KMessageBox.error(self,"Stations 'forward' not implemented","Not Implemented")
