#
# "@(#) $Id: ogginfo.py,v 1.7 2004/08/04 01:01:47 duane Exp $"
#
# This work is released under the GNU GPL, version 2 or later.
#
from backtick import backtick
import re,commands

class OggInfo:
	def __init__(self,filePath):
		self.process(filePath)
	
	def process(self,filePath):
		try:
			command = 'ogginfo '+commands.mkarg(filePath)
			#print command
			result = backtick(command)
			flags = re.MULTILINE | re.IGNORECASE
			#
			# handle standard user comment fields
			#
			try:
				mo = re.search(r"^\s*?TITLE\=(.+)$",result,flags)
				if mo: self.title = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?ARTIST=(.+)$",result,flags)
				if mo: self.artist = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?ALBUM\=(.+)$",result,flags)
				if mo: self.album = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?GENRE\=(.+)$",result,flags)
				if mo: self.genre= mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?DATE\=(.+)$",result,flags)
				if mo: self.year= int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^\s*?TRACKNUMBER\=(.+)$",result,flags)
				if mo: self.trackNum = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^\s*?TRACKCOUNT\=(.+)$",result,flags)
				if mo: self.trackCount = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^\s*?DESCRIPTION\=(.+)$",result,flags)
				if mo: self.description = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?VERSION\=(.+)$",result,flags)
				if mo: self.version = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?PERFORMER\=(.+)$",result,flags)
				if mo: self.performer = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?COPYRIGHT\=(.+)$",result,flags)
				if mo: self.copyright = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?LICENSE\=(.+)$",result,flags)
				if mo: self.license= mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?ORGANIZATION\=(.+)$",result,flags)
				if mo: self.organization = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?LOCATION\=(.+)$",result,flags)
				if mo: self.location = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?CONTACT\=(.+)$",result,flags)
				if mo: self.contact = mo.group(1)
			except: pass
			try:
				mo = re.search(r"^\s*?ISRC\=(.+)$",result,flags)
				if mo: self.ISRC = mo.group(1)
			except: pass
			#
			# handle file encoding info, newer versions of ogginfo
			#
			try:
				mo = re.search(r"^Channels\:\s+?(\d+)$",result,flags)
				if mo: self.channels = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^Rate\:\s+?(\d+)$",result,flags)
				if mo: self.sampleRate = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^\s*?Average bitrate:\s+?(\d+)\.(\d+)\s",result,flags)
				if mo: self.bitRate = int(float(mo.group(1)+'.'+mo.group(2))*1000)
			except: pass
			try:
				mo = re.search(r"^\s*?Nominal bitrate:\s+?(\d+)\.(\d+)\s",result,flags)
				if mo: self.bitRate = int(float(mo.group(1)+'.'+mo.group(2))*1000)
			except: pass
			try:
				mo = re.search(r"^\s*?Playback length:\s+?(\d+)m\:(\d+)",result,flags)
				if mo: self.totalTime = (int(mo.group(1))*60+int(mo.group(2)))*1000
			except: pass
			#
			# same thing, older versions of ogginfo
			#
			try:
				mo = re.search(r"^channels\=(\d+)$",result,flags)
				if mo: self.channels = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^rate\=(\d+)$",result,flags)
				if mo: self.sampleRate = int(mo.group(1))
			except: pass
			try:
				mo = re.search(r"^bitrate_average\=(\d+)\.(\d+)\s",result,flags)
				if mo: self.bitRate = int(float(mo.group(1)+'.'+mo.group(2))*1000)
			except: pass
			try:
				mo = re.search(r"^playtime\=(\d+)\:(\d+)",result,flags)
				if mo: self.totalTime = (int(mo.group(1))*60+int(mo.group(2)))*1000
			except: pass
		except: pass

if __name__=='__main__':
	#o = OggInfo("/home/dmaxwell/Desktop/oggs/Crooked Fingers/A_Little_Bleeding.ogg")
	o = OggInfo("/home/dmaxwell/My Documents/My Music/Lsongs/LsongsMusic/Unknown Artist/Unknown Album/Lullaby.ogg")
	print vars(o)
