import re
from PListParser import *

inFileName = "/home/dmaxwell/rpms/rhythmbox-0.6.5/data/iradio-initial.pls"
outFileName = "/home/dmaxwell/nVox/nVoxRadio.xml"

filePattern = re.compile(r"^file(\d+)=(.*)")
titlePattern = re.compile(r"title(\d+)=(.*)")
genrePattern = re.compile(r"genre(\d+)=(.*)")

genres = {}

fp = open(inFileName,"r")
header = fp.readline()
counter = fp.readline()
while True:
	line = fp.readline()
	#print line
	if line:
		mo = filePattern.match(line)
		if mo: url = mo.group(2)
		else: break
		line = fp.readline()
		mo = titlePattern.match(line)
		if mo: title = mo.group(2)
		else: break
		line = fp.readline()
		mo = genrePattern.match(line)
		if mo: genre = mo.group(2)
		else: break
		#print genre,title,url
		entry = genres.get(genre,None)
		if entry==None:
			entry = []
			genres[genre] = entry
		entry.append({'Title':title,'Location':url,"Genre":genre})
	else:
		break
fp.close()

writer = PListWriter()
writer.unparse([genres],outFileName)
