'''
Defines abstract classes representing the interfaces that must be implemented
by an input device for LSR. All input devices derive from the base class in 
L{AEInput}. Devices that serve double duty as sources of input for LSR as well 
as the rest of the operating system derive from the L{SystemInput} subclass.

Concrete classes implementing the methods of L{AEInput} that ship with LSR are 
not located in this package. Rather, they are stored in the Devices folder and
referenced by the L{UIRegistrar} when they need to be loaded.

@var DEVICE_TYPES: All subinterfaces that distinguish devices of different 
  capabilities
@type DEVICE_TYPES: list of class

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

from Base import AEInput
from SystemInput import SystemInput
from GestureList import GestureList
from Gesture import Gesture
from Error import *
import Constants

DEVICE_TYPES = [SystemInput]