'''
Output related constants.

@todo: PP: document constants
@todo: PP: make common styles into constants

@author: Peter Parente
@author: Scott Haeger
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2007 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
# no-op command for all devices
CMD_NOOP = 0

# common commands for serial output devices (e.g. audio, Braille)
CMD_STOP = 1
CMD_TALK = 2
CMD_STRING = 3
CMD_FILENAME = 5

# commands for Braille devices
BRAILLE_CMD = 0x0010
CMD_CARET = (BRAILLE_CMD | 0x0001)
CMD_TRUNCATE = (BRAILLE_CMD | 0x0002)
CMD_GET_ELLIPSIS_SIZE = (BRAILLE_CMD | 0x0003)
CMD_GET_MISSINGCELL_COUNT = (BRAILLE_CMD | 0x0004)

# commands for audio devices
CMD_INDEX = 7
CMD_STRING_SYNC = 4

# commands for magnifiers
CMD_GOTO = 9
CMD_GET_ROI = 10

# braille constants
# Caret display styles
CARET_NONE = 0
CARET_TWO_BOTTOM = 1
CARET_BOTTOM_RIGHT = 2
CARET_ALL = 3
CARET_LAST = CARET_ALL

# ellipsis display styles
ELLIPSIS_CONTINUATION = 0
ELLIPSIS_ELLIPSIS = 1
ELLIPSIS_LAST = ELLIPSIS_ELLIPSIS

# provide a reverse mapping from command constants to string command names
OUTPUT_COMMAND_NAMES = dict([(value, name.lower()[4:].replace('_', ' '))
                             for name, value in 
                             locals().items() if name.startswith('CMD_')])

# settings common to all devices

# settings common to audio device styles
