/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * NAME
 * 	setsid01.c
 *
 * DESCRIPTION
 * 	Test to check the error and trivial conditions in setsid system call
 *
 * USAGE
 * 	setsid01
 *
 * RESTRICTIONS
 * 	This test doesn't follow good LTP format - PLEASE FIX!
 */
#include <wait.h>
#include <limits.h>
#include <signal.h>
#include <errno.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "test.h"
#include "usctest.h"

#define INVAL_FLAG	-1
#define USER2		301
#define INVAL_MAXGRP	NGROUPS_MAX + 1
#define INVAL_USER	999999	
#define INVAL_PID	999999

char *TCID = "setsid01";
int TST_TOTAL = 1;
extern int Tst_count;

void setup(void);
void cleanup(void);

int main(int ac, char **av)
{
	int pid;
	int retval, fail = 0;
	int ret, status;
	int exno = 0;

	int lc;				/* loop counter */
	char *msg;			/* message returned from parse_opts */

	/* parse standard options */
	if ((msg = parse_opts(ac, av, (option_t *)NULL, NULL)) != (char *)NULL){
		tst_brkm(TBROK, tst_exit, "OPTION PARSING ERROR - %s", msg);
		/*NOTREACHED*/
	}

	/*
	 * perform global setup for the test
	 */
	setup();

	/* check looping state if -i option is given */
	for (lc = 0; TEST_LOOPING(lc); lc++) {

		/* reset Tst_count in case we are looping */
		Tst_count = 0;

		/*
		 * When the process group having forked of a child
		 * and then it attached itself to another process
		 * group and tries to setsid
		 */
		pid = fork();

		if (pid == 0) {
			if ((pid = fork()) == -1) {
				tst_resm(TFAIL, "Fork failed");
				tst_exit();
			}
			if (pid == 0) {
				sleep(1);
				exno = 0;

				if (setpgid(0, 0) < 0) {
					perror("setpgid");
					exno = 1;
				}

				if ((pid = fork()) == -1) {
					tst_resm(TFAIL, "Fork failed");
					tst_exit();
				}
				if (pid == 0) {
					for (;;);
				} else {
					retval = setpgid(0, getppid());
					if (retval < 0) {
						tst_resm(TFAIL, "setpgid "
							 "failed, errno :%d",
							 errno);
						exno = 2;
					}

					retval = setsid();

					if (errno == EPERM) {
						tst_resm(TPASS, "setsid "
							 "SUCCESS to set "
							 "errno to EPERM");
					} else {
						tst_resm(TFAIL, "setsid "
							 "failed, expected %d,"
							 "return %d", -1,
							 errno);
						exno = 3;
					}
					kill(pid, SIGKILL);
					if ((ret = wait(&status)) > 0) {
						tst_resm(TINFO, "Test {%d} "
							 "exited status 0x%-x",
							 ret, status);
						if (status != 9) {
							exno = 4;
						}
					}
				}
				exit(exno);
			} else {
				if (setpgid(0, 0) < 0)  {
					perror("setpgid(parent) failed");
					fail = 1;
				}

				if ((ret = wait(&status)) > 0) {
					tst_resm(TINFO, "Test {%d} exited "
						 "status 0x%0x", ret, status);
					if (status != 0) {
						fail = 1;
					}
				}
			}
			exit(0);
		} else {
			if ((ret = wait(&status)) > 0) {
				tst_resm(TINFO, "Test {%d} exited "
					 "status 0x%0x", ret, status);
				if (status != 0) {
					fail = 1;
				}
			}
		}

		if (fail || exno) {
			tst_resm(TINFO, "Test 1: FAILED");
		} else {
			tst_resm(TINFO, "Test 1: PASSED");
		}
	}
	cleanup();
	/*NOTREACHED*/
	return(0);
}

/*
 * setup() - performs all ONE TIME setup for this test
 */
void
setup(void)
{
	/* capture signals */
	tst_sig(FORK, DEF_HANDLER, cleanup);

	umask(0);

	/* Pause if that option was specified */
	TEST_PAUSE;
}

/*
 * cleanup() - performs all the ONE TIME cleanup for this test at completion
 * 	       or premature exit
 */
void
cleanup(void)
{
	/*
	 * print timing status if that option was specified
	 * print errno log if that option was specified
	 */
	TEST_CLEANUP;

	/* exit with return code appropriate for results */
	tst_exit();
}
