/*
   b_ptr_dir.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Saturday, December 18 at 10:34 AM CST

TITLE
   b_ptr_dir.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_ptr_dir.h"

//--------------------------------------------------------------------


#define TESTDIR2 "testdir2"

static DIR* dirPtr;
static DIR* copy_dirPtr;
//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_ptr_dirTYPENAME,CLASS_STRING);
strcpy(_b_ptr_dirDIR_CLOSED,"b_ptr_dir_DIR_CLOSED");
strcpy(_b_ptr_dirDIR_OPEN,"b_ptr_dir_DIR_OPEN");
strcpy(_b_ptr_dirDIR_REMOVED,"b_ptr_dir_DIR_REMOVED");
strcpy(_b_ptr_dirDIR_MIDWAY,"b_ptr_dir_DIR_MIDWAY");
strcpy(_b_ptr_dirEMPTY,"b_ptr_dir_EMPTY");
strcpy(_b_ptr_dirWITH_FILES,"b_ptr_dir_WITH_FILES");
}

//--------------------------------------------------------------------
b_param *b_ptr_dir::b_ptr_dirDIR_CLOSED()
{
   return &_b_ptr_dirDIR_CLOSED;
}

b_param *b_ptr_dir::b_ptr_dirDIR_OPEN()
{
   return &_b_ptr_dirDIR_OPEN;
}

b_param *b_ptr_dir::b_ptr_dirDIR_REMOVED()
{
   return &_b_ptr_dirDIR_REMOVED;
}

b_param *b_ptr_dir::b_ptr_dirDIR_MIDWAY()
{
   return &_b_ptr_dirDIR_MIDWAY;
}

b_param *b_ptr_dir::b_ptr_dirEMPTY()
{
   return &_b_ptr_dirEMPTY;
}

b_param *b_ptr_dir::b_ptr_dirWITH_FILES()
{
   return &_b_ptr_dirWITH_FILES;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_ptr_dirTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_ptr_dir_dir_closed = 0;
b_ptr_dir_dir_open = 0;
b_ptr_dir_dir_removed = 0;
b_ptr_dir_dir_midway = 0;
b_ptr_dir_empty = 0;
b_ptr_dir_with_files = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_dirDIR_CLOSED)==0)
      b_ptr_dir_dir_closed = 1;
   else if (strcmp(data[dataPTR],_b_ptr_dirDIR_OPEN)==0)
      b_ptr_dir_dir_open = 1;
   else if (strcmp(data[dataPTR],_b_ptr_dirDIR_REMOVED)==0)
      b_ptr_dir_dir_removed = 1;
   else if (strcmp(data[dataPTR],_b_ptr_dirDIR_MIDWAY)==0)
      b_ptr_dir_dir_midway = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"STATE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_dirEMPTY)==0)
      b_ptr_dir_empty = 1;
   else if (strcmp(data[dataPTR],_b_ptr_dirWITH_FILES)==0)
      b_ptr_dir_with_files = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"CONTENT"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

 int withFileFlag = 0;
 dirPtr = NULL;
 copy_dirPtr = NULL;

 
 system("rm -rf testdir2");

 
 FILE* logFile = NULL;
 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }

 if (mkdir(TESTDIR2,S_IRWXU|S_IRWXG|S_IRWXO)!=0) /* create test directory, u+rwx */
 {
 
 if (errno != EEXIST) 
 {
 fprintf (logFile, "b_ptr_dir error creating directory testdir2 - values not tested\n");
 fclose(logFile);
 exit(99);
 }
 }

if (b_ptr_dir_with_files==1)
{

 char fname[16];
 int i;
 FILE* filePtr = NULL;
 for (i=0; i < 5; i++)
 {
 strcpy(fname,"testfile");
 sprintf (&fname[8], "%d", i);
 if ((filePtr = fopen(fname, "w+")) == NULL)
 {
 fprintf(logFile,"b_ptr_dir WITH_FILES -error creating file - value not tested\n");
 fclose(logFile);
 exit(99);
 }

 fprintf(filePtr, "This is a testfile!\n");
 fclose(filePtr);
 }
 withFileFlag = 1;
 
}

 if ((dirPtr = opendir(TESTDIR2)) == NULL)
 {
 fprintf (logFile,"b_ptr_dir - error opening directory - value not tested\n");
 fclose(logFile);
 exit(99);
 }

if (b_ptr_dir_dir_closed==1)
{

 if (closedir (dirPtr) == -1) 
 {
 fprintf (logFile, "b_ptr_dir.tpl CLOSED - unable to close directory - value not tested \n");
 fclose(logFile);
 exit(99);
 }
 _theVariable = dirPtr;
 copy_dirPtr = dirPtr; 
 
}

if (b_ptr_dir_dir_open==1)
{
 
 _theVariable = dirPtr; 
 copy_dirPtr = dirPtr;
 
}

if (b_ptr_dir_dir_midway==1)
{

 struct dirent* temp_dirent = NULL;

 if (withFileFlag)
 {
 if ((temp_dirent = readdir(dirPtr))==NULL)
 {
 fprintf(logFile,"b_ptr_dir.tpl DIR_MIDWAY - error reading through files in directory - value not tested\n");
 fclose(logFile);
 exit(99);
 }
 }
 _theVariable = dirPtr;
 copy_dirPtr = dirPtr;
 
}

if (b_ptr_dir_dir_removed==1)
{

 if (rmdir(TESTDIR2) != 0) 
 {
 fprintf(logFile, "b_ptr_dir DIR_REMOVED - error encountered removing directory - value not tested\n");
 fclose(logFile);
 exit(99);
 }
 _theVariable = dirPtr;
 copy_dirPtr = dirPtr;
 
}

 fclose(logFile);
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated

if (b_ptr_dir_dir_open==1 || b_ptr_dir_dir_midway==1)
{

 closedir(copy_dirPtr);
 
}
 
 system("rm -rf testdir2");
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 4;
      break;

   case 2:
      return 2;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_ptr_dirDIR_CLOSED();
         break;
      case 2:
         return b_ptr_dirDIR_OPEN();
         break;
      case 3:
         return b_ptr_dirDIR_REMOVED();
         break;
      case 4:
         return b_ptr_dirDIR_MIDWAY();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;

case 2:
 switch (position)
   {
      case 1:
         return b_ptr_dirEMPTY();
         break;
      case 2:
         return b_ptr_dirWITH_FILES();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
